<?php
/**
 * IIS Ticketing
 */

/**
 *Data Access Object for `iisticket_categories` table.
 *
 * @author Mohammad Agha Abbasloo <a.mohammad85@gmail.com>
 * @package ow_plugins.iisticketing.bol
 * @since 1.0
 */
class IISTICKETING_BOL_TicketCategoryDao extends OW_BaseDao
{
    /**
     * Singleton instance.
     *
     * @var IISTICKETING_BOL_TicketCategoryDao
     */
    private static $classInstance;

    /**
     * Returns an instance of class (singleton pattern implementation).
     *
     * @return IISTICKETING_BOL_TicketCategoryDao
     */
    public static function getInstance()
    {
        if ( self::$classInstance === null )
        {
            self::$classInstance = new self();
        }

        return self::$classInstance;
    }

    /**
     * Constructor.
     */
    protected function __construct()
    {
        parent::__construct();
    }

    /**
     * @see OW_BaseDao::getDtoClassName()
     *
     */
    public function getDtoClassName()
    {
        return 'IISTICKETING_BOL_TicketCategory';
    }

    /**
     * @see OW_BaseDao::getTableName()
     *
     */
    public function getTableName()
    {
        return OW_DB_PREFIX . 'iisticketing_categories';
    }

    public function findIsExistTitle($title)
    {
        $ex = new OW_Example();
        $ex->andFieldEqual('title', $title);
        return $this->findObjectByExample($ex);
    }

}