<?php
class IISTICKETING_CTRL_AddTicket extends OW_ActionController
{

    /**
     * Class constructor
     */

    private $ticketService;

    public function __construct()
    {
        parent::__construct();
        $this->ticketService= IISTICKETING_BOL_TicketService::getInstance();

    }

    public function index( array $params )
    {
        $language = OW::getLanguage();
        $this->setPageTitle($language->text('iisticketing', 'add_ticket_page_title'));

        $uid = IISSecurityProvider::generateUniqueId();

        $addTicketForm = $this->generateAddTicketForm($uid);
        $attachmentCmp = new BASE_CLASS_FileAttachment('iisticketing', $uid);
        $this->addComponent('attachmentsCmp', $attachmentCmp);
        if ( OW::getRequest()->isPost() && $addTicketForm->isValid($_POST) )
        {
            $data = $addTicketForm->getValues();

            $ticketDto = $this->ticketService->addTicket($data);
            if(isset($ticketDto))
            {
                $this->sendNewTicketNotification($ticketDto);
            }
            $redirectUrl=OW::getRouter()->urlForRoute('iisticketing.view_ticket',array('ticketId'=>$ticketDto->id));
            $this->redirect($redirectUrl);
        }
    }

    private function sendNewTicketNotification($ticketDto)
    {
        $proceedPermissions=array();
        $users=array();
        $authorizationGroup= BOL_AuthorizationGroupDao::getInstance()->findByName('iisticketing');
        $action = BOL_AuthorizationActionDao::getInstance()->findAction('view_tickets',$authorizationGroup->id);
        $authorizationPermissions= BOL_AuthorizationPermissionDao::getInstance()->findByActionId($action->id);
        foreach ($authorizationPermissions as $authorizationPermission)
        {
            if(in_array($authorizationPermission->roleId,$proceedPermissions))
            {
                continue;
            }
            $userCount = (int)BOL_UserService::getInstance()->countByRoleId($authorizationPermission->roleId);
            $users= BOL_UserService::getInstance()->findListByRoleId($authorizationPermission->roleId,0,$userCount);
            array_push($proceedPermissions,(int)$authorizationPermission->roleId);
        }
        $avatars = BOL_AvatarService::getInstance()->getDataForUserAvatars(array($ticketDto->userId));
        $actor = array(
            'name' => BOL_UserService::getInstance()->getDisplayName($ticketDto->userId),
            'url' => BOL_UserService::getInstance()->getUserUrl($ticketDto->userId)
        );
        $description = nl2br(UTIL_String::truncate($ticketDto->description, 300, '...'));
        foreach ( $users as  $user ) {
            if($user->getId() ==$ticketDto->userId){
                continue;
            }
            $notifService = NOTIFICATIONS_BOL_Service::getInstance();
            $notification = $notifService->findNotification('ticket-add', (int)$ticketDto->id, $user->getId());
            if(isset($notification)) {
                $notification->sent = 0;
                $notification->viewed = 0;
                $notifService->saveNotification($notification);
            }else {
                $event = new OW_Event('notifications.add', array(
                    'pluginKey' => 'iisticketing',
                    'entityType' => 'ticket-add',
                    'entityId' => (int)$ticketDto->id,
                    'action' => 'receive-ticket-update',
                    'userId' => $user->getId(),
                    'time' => time()
                ), array(
                    'avatar' => $avatars[$ticketDto->userId],
                    'string' => array(
                        'key' => 'iisticketing+ticket_notification_string',
                        'vars' => array(
                            'actor' => $actor['name'],
                            'actorUrl' => $actor['url'],
                            'title' => $ticketDto->title,
                            'url' => OW::getRouter()->urlForRoute('iisticketing.view_ticket', array('ticketId' => $ticketDto->id))
                        )
                    ),
                    'content' => $description,
                    'url' => OW::getRouter()->urlForRoute('iisticketing.view_ticket', array('ticketId' => $ticketDto->id))
                ));
                OW::getEventManager()->trigger($event);
            }
        }
    }
    /**
     * Generates add ticket form.
     *
     * @param string $uid
     * @return Form
     */
    private function generateAddTicketForm($uid)
    {
        $form = new IISTICKETING_CLASS_TicketForm(
            'add-ticket-form',
            $uid,
            null,
            false
        );

        $form->setAction(OW::getRouter()->urlForRoute('iisticketing.add-ticket'));
        $this->addForm($form);
        return $form;
    }

}

