<?php
/**
 * User: Elahe
 * Date: 2/27/2019
 * Time: 9:09 PM
 */


class IISTICKETING_CTRL_Admin extends ADMIN_CTRL_Abstract
{

    public function __construct()
    {
        parent::__construct();

//        $this->setPageHeading(OW::getLanguage()->text('iisticketing', 'settings_page_heading'));
        $this->setPageHeadingIconClass('ow_ic_gear_wheel');
    }

    /**
     * Default action
     */

    const CATEGORY_SECTION=1;
    const ORDER_SECTION=2;
    const CATEGORY_TYPE='category';
    const ORDER_TYPE='order';
    public function index(array $params = array())
    {
        $language = OW::getLanguage();
        $this->setPageHeading($language->text('iisticketing', 'settings_page_heading'));
        $this->setPageTitle($language->text('iisticketing', 'settings_page_title'));
        $currentSectionFromParams = null;
        if(isset($params['currentSection'])) {
            $currentSectionFromParams = $params['currentSection'];
        }
        $sectionsInformation = IISTICKETING_BOL_TicketService::getInstance()->getSections($currentSectionFromParams);
        $sections = $sectionsInformation['sections'];
        $currentSection = $sectionsInformation['currentSection'];
        $this->assign('sections',$sections);
        $this->assign('currentSection',$currentSection);
        if($currentSection==1) {
            $categoryService= IISTICKETING_BOL_TicketCategoryService::getInstance();
            $language = OW::getLanguage();
            $form = new Form('categorySettings');
            $form->setAjax(false);
            $form->setAction(OW::getRouter()->urlForRoute('iisticketing.admin-currentSection',array('currentSection'=>$currentSection)));

            $deleteUrls = array();
            $ticketListCategory=array();
            $ticketCategories = $categoryService->getTicketCategoryList();
            $editUrls = [];
            foreach ($ticketCategories as $ticketCategory) {
                $editUrls[$ticketCategory->id] =  "OW.ajaxFloatBox('IISTICKETING_CMP_EditCategoryFloatBox', {id: ".$ticketCategory->id."} , {iconClass: 'ow_ic_edit', title: '".$language->text('iisticketing', 'edit_item')."'})";

                $ticketListCategory[$ticketCategory->id]['name'] = $ticketCategory->id;
                $ticketListCategory[$ticketCategory->id]['title'] = $ticketCategory->title;
                $deleteUrls[$ticketCategory->id] = OW::getRouter()->urlFor(__CLASS__, 'deleteItem', array('id' => $ticketCategory->id,'type'=>self::CATEGORY_TYPE));
            }
            $this->assign('ticketListCategory', $ticketListCategory);
            $this->assign('deleteUrls', $deleteUrls);
            $this->assign('editUrls',$editUrls);
            $this->addForm($form);

            $fieldTitle = new TextField('title');
            $fieldTitle->setRequired();
            $fieldTitle->setInvitation($language->text('iisticketing', 'category_title_label'));
            $fieldTitle->setHasInvitation(true);
            $validator = new IISTICKETING_CLASS_CategoryTitleValidator();
            $validator->setErrorMessage($language->text('iisticketing', 'title_error_already_exist'));
            $fieldTitle->addValidator($validator);
            $form->addElement($fieldTitle);

            $submit = new Submit('add');
            $submit->setValue($language->text('iisticketing', 'form_add_category_submit'));
            $form->addElement($submit);
            if (OW::getRequest()->isPost()) {
                if ($form->isValid($_POST)) {
                    $data = $form->getValues();
                    $categoryService->addCategory($data['title']);
                    OW::getFeedback()->info($language->text('iisticketing', 'settings_saved_successfully'));
                    $this->redirect();
                }
            }
        }else if($currentSection==2) {
            $orderService= IISTICKETING_BOL_TicketOrderService::getInstance();
            $language = OW::getLanguage();
            $form = new Form('orderSettings');
            $form->setAjax(false);
            $form->setAction(OW::getRouter()->urlForRoute('iisticketing.admin-currentSection',array('currentSection'=>$currentSection)));

            $deleteUrls = array();
            $ticketListOrder=array();
            $ticketOrders = $orderService->getTicketOrderList();
            $editUrls = [];
            foreach ($ticketOrders as $ticketOrder) {
                $editUrls[$ticketOrder->id] =  "OW.ajaxFloatBox('IISTICKETING_CMP_EditOrderFloatBox', {id: ".$ticketOrder->id."} , {iconClass: 'ow_ic_edit', title: '".$language->text('iisticketing', 'edit_item_page_title')."'})";

                $ticketListOrder[$ticketOrder->id]['name'] = $ticketOrder->id;
                $ticketListOrder[$ticketOrder->id]['title'] = $ticketOrder->title;
                $deleteUrls[$ticketOrder->id] = OW::getRouter()->urlFor(__CLASS__, 'deleteItem', array('id' => $ticketOrder->id,'type'=>self::ORDER_TYPE));
            }
            $this->assign('ticketListOrder', $ticketListOrder);
            $this->assign('deleteUrls', $deleteUrls);
            $this->assign('editUrls',$editUrls);
            $this->addForm($form);

            $fieldTitle = new TextField('title');
            $fieldTitle->setRequired();
            $fieldTitle->setInvitation($language->text('iisticketing', 'order_title_label'));
            $fieldTitle->setHasInvitation(true);
            $validator = new IISTICKETING_CLASS_OrderTitleValidator();
            $validator->setErrorMessage($language->text('iisticketing', 'title_error_already_exist'));
            $fieldTitle->addValidator($validator);
            $form->addElement($fieldTitle);

            $submit = new Submit('add');
            $submit->setValue($language->text('iisticketing', 'form_add_order_submit'));
            $form->addElement($submit);
            if (OW::getRequest()->isPost()) {
                if ($form->isValid($_POST)) {
                    $data = $form->getValues();
                    $orderService->addOrder($data['title']);
                    OW::getFeedback()->info($language->text('iisticketing', 'settings_saved_successfully'));
                    $this->redirect();
                }
            }
        }
    }

    public function deleteItem( $params )
    {
        switch ($params['type'])
        {
            case self::CATEGORY_TYPE:
                if ( isset($params['id']))
                {
                    IISTICKETING_BOL_TicketCategoryService::getInstance()->deleteCategory((int) $params['id']);
                }
                OW::getFeedback()->info(OW::getLanguage()->text('iisticketing', 'database_record_deleted'));
                $this->redirect(OW::getRouter()->urlForRoute('iisticketing.admin-currentSection',array('currentSection'=>self::CATEGORY_SECTION)));
                break;
            case self::ORDER_TYPE:
                if ( isset($params['id']))
                {
                    IISTICKETING_BOL_TicketOrderService::getInstance()->deleteOrder((int) $params['id']);
                }
                OW::getFeedback()->info(OW::getLanguage()->text('iisticketing', 'database_record_deleted'));
                $this->redirect(OW::getRouter()->urlForRoute('iisticketing.admin-currentSection',array('currentSection'=>self::ORDER_SECTION)));
                break;
        }
    }

    public function editCategoryItem()
    {
        $form =  IISTICKETING_BOL_TicketCategoryService::getInstance()->getItemForm($_POST['id']);
        if ( $form->isValid($_POST) ) {
            IISTICKETING_BOL_TicketCategoryService::getInstance()->editCategoryItem($form->getElement('id')->getValue(), $form->getElement('title')->getValue());
            OW::getFeedback()->info(OW::getLanguage()->text('iisticketing', 'database_record_edit'));
            $this->redirect(OW::getRouter()->urlForRoute('iisticketing.admin-currentSection',array('currentSection'=>self::CATEGORY_SECTION)));
        }else{
            if($form->getErrors()['label'][0]!=null) {
                OW::getFeedback()->error($form->getErrors()['label'][0]);
            }
            $this->redirect(OW::getRouter()->urlForRoute('iisticketing.admin-currentSection',array('currentSection'=>self::CATEGORY_SECTION)));
        }
    }

    public function manageOrderItem()
    {
        $form =  IISTICKETING_BOL_TicketOrderService::getInstance()->getItemForm($_POST['id']);
        if ( $form->isValid($_POST) ) {
            IISTICKETING_BOL_TicketOrderService::getInstance()->editOrderItem($form->getElement('id')->getValue(), $form->getElement('title')->getValue());
            OW::getFeedback()->info(OW::getLanguage()->text('iisticketing', 'database_record_edit'));
            $this->redirect(OW::getRouter()->urlForRoute('iisticketing.admin-currentSection',array('currentSection'=>self::ORDER_SECTION)));
        }else{
            if($form->getErrors()['label'][0]!=null) {
                OW::getFeedback()->error($form->getErrors()['label'][0]);
            }
            $this->redirect(OW::getRouter()->urlForRoute('iisticketing.admin-currentSection',array('currentSection'=>1)));
        }
    }

    public function editOrderItem()
    {
        $form =  IISTICKETING_BOL_TicketOrderService::getInstance()->getItemForm($_POST['id']);
        if ( $form->isValid($_POST) ) {
            IISTICKETING_BOL_TicketOrderService::getInstance()->editOrderItem($form->getElement('id')->getValue(), $form->getElement('title')->getValue());
            OW::getFeedback()->info(OW::getLanguage()->text('iisticketing', 'database_record_edit'));
            $this->redirect(OW::getRouter()->urlForRoute('iisticketing.admin-currentSection',array('currentSection'=>self::ORDER_SECTION)));
        }else{
            if($form->getErrors()['label'][0]!=null) {
                OW::getFeedback()->error($form->getErrors()['label'][0]);
            }
            $this->redirect(OW::getRouter()->urlForRoute('iisticketing.admin-currentSection',array('currentSection'=>1)));
        }
    }


}
