<?php
class IISTICKETING_CTRL_Ticket extends OW_ActionController
{

    /**
     * Class constructor
     */
    public function __construct()
    {
        parent::__construct();

    }

    public function viewList()
    {
        if (!OW::getUser()->isAuthenticated())
        {
            throw new Redirect404Exception();
        }
        $language=OW::getLanguage();
        $this->setPageHeading($language->text('iisticketing', 'ticket_list_page_heading'));
        $this->setPageTitle($language->text('iisticketing', 'ticket_list_page_title'));

        $hasAccessAllTickets = OW::getUser()->isAuthorized('iisticketing', 'view_tickets') || OW::getUser()->isAdmin();

        $ticketService = IISTICKETING_BOL_TicketService::getInstance();

        $ticketService->setFilterParameters();

        $searchForm= $ticketService->getTicketFilterForm('searchForm');
        $this->addForm($searchForm);
        $filterFormElementsKey = array();
        foreach ($searchForm->getElements() as $element) {
            if ($element->getAttribute('type') != 'hidden') {
                $filterFormElementsKey[] = $element->getAttribute('name');
            }
        }
        $this->assign('filterFormElementsKey', $filterFormElementsKey);

        $url = OW::getRouter()->urlForRoute('iisticketing.view_tickets');
        $this->assign('url',$url);

        $userId = OW::getUser()->getId();

        $plugin = OW::getPluginManager()->getPlugin('iisticketing');
        OW::getDocument()->addScript($plugin->getStaticJsUrl() . "ticket.js");

        $page = !empty($_GET['page']) && (int) $_GET['page'] ? abs((int) $_GET['page']) : 1;
        $pageCount = IISTICKETING_BOL_TicketService::TICKET_PER_PAGE;
        if($hasAccessAllTickets)
        {
            $ticketList = $ticketService->findAllTickets($page);
            $ticketListCount = $ticketService->findAllTicketsCount();
        }else{
            $ticketList = $ticketService->findTicketsByUserId($userId, $page);
            $ticketListCount = $ticketService->findTicketsByUserIdCount($userId);
        }
        $ticketInfoComponent = new IISTICKETING_CMP_TicketListInfo($ticketList,$ticketListCount,$page,$pageCount);
        $this->addComponent('ticketInfoComponent',$ticketInfoComponent);
    }

    public function getTicketUrl($ticketId)
    {
        return OW::getRouter()->urlForRoute('iisticketing.view_ticket',array('ticketId'=>$ticketId));
    }

    public function view($params)
    {
        if (!OW::getUser()->isAuthenticated()) {
            throw new Redirect404Exception();
        }

        if(!isset($params['ticketId']))
        {
            throw new Redirect404Exception();
        }

        $ticketService = IISTICKETING_BOL_TicketService::getInstance();
        $ticketDto=$ticketService->findTicketById($params['ticketId']);
        if(!isset($ticketDto))
        {
            throw new Redirect404Exception();
        }
        $isTicketManager = OW::getUser()->isAuthorized('iisticketing', 'view_tickets')|| OW::getUser()->isAdmin();
        $isOwner=OW::getUser()->getId()==$ticketDto->userId;
        $isManager = OW::getUser()->isAuthorized('iisticketing');
        $canPost= $isTicketManager || $isOwner;
        if(!$isTicketManager && !$isOwner)
        {
            throw new Redirect404Exception();
        }


        $ticketInfo=$ticketService->findTicketInfoById($params['ticketId']);
        $this->setPageHeading($ticketInfo['title']);
        $networkUrl=null;
        $networkUid=null;
        if(isset($ticketInfo['networkUid']))
        {
            $networkUid=$ticketInfo['networkUid'];
            if(class_exists('SaasProvider')) {
                $networkUrl = SaasProvider::getNetworkUrlHome($networkUid);
            }
        }else{
            $addition= json_decode($ticketInfo['addition'],true);
            if(isset($addition['networkUid'])){
                $networkUid = $addition['networkUid'];
            }
        }

        $bcItems = array(
            array(
                'href' => OW::getRouter()->urlForRoute('iisticketing.view_tickets'),
                'label' => OW::getLanguage()->text('iisticketing', 'ticket_list_page_title')
            )
        );

        $breadCrumbCmp = new BASE_CMP_Breadcrumb($bcItems);
        $this->addComponent('breadcrumb', $breadCrumbCmp);

        $avatar = BOL_AvatarService::getInstance()->getDataForUserAvatars(array($ticketInfo['userId']), true, false);

        $avatar[$ticketInfo['userId']]['url'] = BOL_UserService::getInstance()->getUserUrl($ticketInfo['userId']);
        $userService = BOL_UserService::getInstance();

        $ticketInfoArr = array(
            'id' => $ticketInfo['id'],
            'userId' => $ticketInfo['userId'],
            'displayName' => $userService->getDisplayName($ticketInfo['userId']),
            'username'  => $userService->getUserName($ticketInfo['userId']),
            'authorAvatar' =>$avatar[$ticketInfo['userId']],
            'title' =>$ticketInfo['title'],
            'locked'=>$ticketInfo['locked'],
            'description' => UTIL_HtmlTag::stripJs($ticketInfo['description']),
            'timeStamp' => UTIL_DateTime::formatDate($ticketInfo['timeStamp']),
            'ticketUrl' => $this->getTicketUrl($ticketInfo['id']),
            'categoryTitle' =>$ticketInfo['categoryTitle'],
            'orderTitle' =>$ticketInfo['orderTitle'],
            'networkUid'=>$networkUid,
            'networkUrl'=>$networkUrl
        );
        $this->assign('ticketInfo',$ticketInfoArr);
        $page = !empty($_GET['page']) && (int) $_GET['page'] ? abs((int) $_GET['page']) : 1;

        $ticketPostList = $ticketService->findTicketPostList($ticketDto->id, $page);

        $this->assign('isOwner', $isOwner);
        $this->assign('userId', OW::getUser()->getId());
        $this->assign('canPost', $canPost);
        $this->assign('isTicketManager', $isTicketManager);
        $this->assign('isManager', $isManager);


        $toolbars = array();
        $lang = OW::getLanguage();

        $langQuote = $lang->text('iisticketing', 'post_quote');
        $langEdit = $lang->text('iisticketing', 'post_edit');
        $langDelete = $lang->text('iisticketing', 'post_delete');

        $iteration = 0;
        $userIds = array();
        $postIds = array();
        $postAttachment=array();
        $attachmentService = IISTICKETING_BOL_TicketAttachmentService::getInstance();
        foreach ( $ticketPostList as &$post )
        {
            $post['text'] = UTIL_HtmlTag::linkify($post['text']);
            $post['permalink'] = $ticketService->getPostUrl($post['ticketId'], $post['id'], true, $page);
            $post['number'] = ($page - 1) * $ticketService::POST_PER_PAGE + $iteration + 1;

            $text = explode("<!--more-->", $post['text']);
            $isPreview = count($text) > 1;
            if ( $isPreview ){
                $post['showMore'] = true;
                $post['beforeMoreText'] = $text[0];
                $post['afterMoreText'] = $text[1];
            }
            else{
                $post['beforeMoreText'] = $post['text'];
            }
            // get list of users
            if ( !in_array($post['userId'], $userIds) )
                $userIds[$post['userId']] = $post['userId'];

            $toolbar = array();

            $label = OW::getLanguage()->text('iisticketing', 'toolbar_post_number', array("num"=> $post['number'] ));
            array_push($toolbar, array('class' => 'post_permalink', 'href' => $post['permalink'], 'label' => $label));

            if ( !$ticketDto->locked &&  $canPost )
            {
                array_push($toolbar, array('id' => $post['id'], 'class' => 'quote_post', 'href' => 'javascript://', 'label' => $langQuote));
            }

            if ( $isManager || (OW::getUser()->getId()== $post['userId'] && !$ticketDto->locked) )
            {
                $href = OW::getRouter()->urlForRoute('iisticketing.edit-post', array('postId' => $post['id']));

                array_push($toolbar, array('id' => $post['id'], 'href' => $href, 'label' => $langEdit));

                array_push($toolbar, array('id' => $post['id'], 'class' => 'delete_post', 'href' => 'javascript://', 'label' => $langDelete));
            }

            $toolbars[$post['id']] = $toolbar;

            if ( count($post['edited']) && !in_array($post['edited']['userId'], $userIds) )
                $userIds[$post['edited']['userId']] = $post['edited']['userId'];

            $iteration++;
            array_push($postIds, $post['id']);
        }

        $postAttachment = $attachmentService->findAttachmentsByEntityIdList($postIds,IISTICKETING_BOL_TicketAttachmentDao::POST_TYPE);
        $postAttachment = $ticketService->addIconsToTicketAttachments($postAttachment);

        $this->assign('postAttachment', $postAttachment);

        $this->assign('toolbars', $toolbars);
        $avatars = BOL_AvatarService::getInstance()->getDataForUserAvatars($userIds);
        $this->assign('avatars', $avatars);

        $uid = IISSecurityProvider::generateUniqueId();
        $addPostForm = $this->generateAddPostForm($ticketDto->id, $uid);
        $this->addForm($addPostForm);

        $addPostInputId = $addPostForm->getElement('text')->getId();
        $attachments = $attachmentService->findAttachmentsByEntityIdList(array($ticketInfo['id']),IISTICKETING_BOL_TicketAttachmentDao::TICKET_TYPE);
        $attachments = $ticketService->addIconsToTicketAttachments($attachments);
        if( isset($attachments[$ticketInfo['id']]) ){
            $this->assign('attachments', $attachments[$ticketInfo['id']]);
        }
        else{
            $this->assign('attachments', array());
        }


        $attachmentCmp = new BASE_CLASS_FileAttachment('iisticketing', $uid);
        $this->addComponent('attachmentsCmp', $attachmentCmp);


        /**
         * deletePostCode
         */
        $postDeleteCode='';
        $iisSecuritymanagerEvent= OW::getEventManager()->trigger(new OW_Event('iissecurityessentials.on.generate.request.manager',
            array('senderId'=>Ow::getUser()->getId(),'receiverId'=>$ticketDto->id,'isPermanent'=>true,'activityType'=>'delete_ticket_post')));
        if(isset($iisSecuritymanagerEvent->getData()['code'])){
            $postDeleteCode = $iisSecuritymanagerEvent->getData()['code'];
        }
        $deletePostUrl = OW::getRequest()->buildUrlQueryString(OW::getRouter()->urlForRoute('iisticketing.delete-post',
            array('ticketId' => $ticketDto->id, 'postId' => 'postId')),array('code' =>$postDeleteCode));

        /**
         * lockTicketCode
         */
        $lockTicketCode='';
        $iisSecuritymanagerEvent= OW::getEventManager()->trigger(new OW_Event('iissecurityessentials.on.generate.request.manager',
            array('senderId'=>Ow::getUser()->getId(),'receiverId'=>$ticketDto->id,'isPermanent'=>true,'activityType'=>'lock_ticket')));
        if(isset($iisSecuritymanagerEvent->getData()['code'])){
            $lockTicketCode = $iisSecuritymanagerEvent->getData()['code'];
        }
        $lockTicketUrl = OW::getRequest()->buildUrlQueryString(OW::getRouter()->urlForRoute('iisticketing.lock-ticket', array('ticketId' => $ticketDto->id, 'page' => $page))
            ,array('code' =>$lockTicketCode));
        /**
         * deleteTicketCode
         */
        $deleteTicketCode='';
        $iisSecuritymanagerEvent= OW::getEventManager()->trigger(new OW_Event('iissecurityessentials.on.generate.request.manager',
            array('senderId'=>Ow::getUser()->getId(),'receiverId'=>$ticketDto->id,'isPermanent'=>true,'activityType'=>'delete_ticket')));
        if(isset($iisSecuritymanagerEvent->getData()['code'])){
            $deleteTicketCode = $iisSecuritymanagerEvent->getData()['code'];
        }
        $deleteTicketUrl = OW::getRequest()->buildUrlQueryString(OW::getRouter()->urlForRoute('iisticketing.delete-ticket', array('ticketId' => $ticketDto->id))
            ,array('code' =>$deleteTicketCode));

        $getPostUrl = OW::getRouter()->urlForRoute('iisticketing.get-post', array('postId' => 'postId'));
        $ticketInfoJs = json_encode(array('locked' => $ticketDto->locked));

        /**
         * editTicketCode
         */
        $editTicketCode='';
        $iisSecuritymanagerEvent= OW::getEventManager()->trigger(new OW_Event('iissecurityessentials.on.generate.request.manager',
            array('senderId'=>Ow::getUser()->getId(),'receiverId'=>$ticketDto->id,'isPermanent'=>true,'activityType'=>'edit_ticket')));
        if(isset($iisSecuritymanagerEvent->getData()['code'])){
            $editTicketCode = $iisSecuritymanagerEvent->getData()['code'];
        }
        $editTicketUrl = OW::getRouter()->urlForRoute('iisticketing.edit-ticket', array('ticketId' => $ticketDto->id));
        $this->assign('editTicketUrl',$editTicketUrl);
        $onloadJs = "
			Ticket.deletePostUrl = '$deletePostUrl';
			Ticket.lockTicketUrl = '$lockTicketUrl';
			Ticket.deleteTicketUrl = '$deleteTicketUrl';
			Ticket.getPostUrl = '$getPostUrl';
			Ticket.add_post_input_id = '$addPostInputId';
			Ticket.construct($ticketInfoJs);
			";

        OW::getDocument()->addOnloadScript($onloadJs);

        $plugin = OW::getPluginManager()->getPlugin('iisticketing');

        OW::getDocument()->addScript($plugin->getStaticJsUrl() . "ticket.js");

        // add language keys for javascript
        $lang->addKeyForJs('iisticketing', 'sticky_topic_confirm');
        $lang->addKeyForJs('iisticketing', 'unsticky_topic_confirm');
        $lang->addKeyForJs('iisticketing', 'lock_topic_confirm');
        $lang->addKeyForJs('iisticketing', 'unlock_topic_confirm');
        $lang->addKeyForJs('iisticketing', 'delete_topic_confirm');
        $lang->addKeyForJs('iisticketing', 'delete_post_confirm');
        $lang->addKeyForJs('iisticketing', 'edit_topic_title');
        $lang->addKeyForJs('iisticketing', 'edit_post_title');
        $lang->addKeyForJs('iisticketing', 'move_topic_title');
        $lang->addKeyForJs('iisticketing', 'confirm_delete_attachment');
        $lang->addKeyForJs('iisticketing', 'lock_ticket_confirm');
        $lang->addKeyForJs('iisticketing', 'delete_ticket_confirm');
        $lang->addKeyForJs('iisticketing', 'unlock_ticket_confirm');
        $lang->addKeyForJs('iisticketing', 'ticket_quote');
        $lang->addKeyForJs('iisticketing', 'ticket_quote_from');


        //posts count on page
        $count = $ticketService::POST_PER_PAGE;

        $postCount = $ticketService->findTicketPostCount($ticketDto->id);
        $pageCount = ceil($postCount / $count);

        $Paging = new BASE_CMP_Paging($page, $pageCount, $count);

        $this->assign('paging', $Paging->render());
        $this->assign('postList', $ticketPostList);
        $this->assign('page', $page);
        $this->assign('backUrl', OW::getRouter()->urlForRoute('iisticketing.view_tickets'));
        $iisSecuritymanagerEvent= OW::getEventManager()->trigger(new OW_Event('iissecurityessentials.on.generate.request.manager',
            array('senderId'=>Ow::getUser()->getId(),'receiverId'=>$ticketDto->id,'isPermanent'=>true,'activityType'=>'delete_attachment')));
        if(isset($iisSecuritymanagerEvent->getData()['code'])){
            $attachmentDeleteCode = $iisSecuritymanagerEvent->getData()['code'];
            $this->assign('attachmentDeleteCode',$attachmentDeleteCode);
        }
    }


    /**
     * This action adds a post and after execution redirects to default action
     *
     * @param array $params
     * @throws Redirect404Exception
     * @throws AuthenticateException
     */
    public function addPost( array $params )
    {
        $ticketService = IISTICKETING_BOL_TicketService::getInstance();

        if ( !isset($params['ticketId']) || !($ticketId = (int) $params['ticketId']) )
        {
            throw new Redirect404Exception();
        }

        $ticketDto = $ticketService->findTicketById($ticketId);

        if ( !$ticketDto )
        {
            throw new Redirect404Exception();
        }

        $isTicketManager = OW::getUser()->isAuthorized('iisticketing', 'view_tickets')|| OW::getUser()->isAdmin();
        $isOwner=OW::getUser()->getId()==$ticketDto->userId;
        if ( !$isTicketManager && $isOwner )
        {
            throw new Redirect404Exception();
        }

        $uid = $params['uid'];

        $addPostForm = $this->generateAddPostForm($ticketId, $uid);

        if ( OW::getRequest()->isPost() && $addPostForm->isValid($_POST) )
        {
            $data = $addPostForm->getValues();

            if ( $data['ticket'] && $data['ticket'] == $ticketDto->id && !$ticketDto->locked )
            {
                if ( !OW::getUser()->getId() )
                {
                    throw new AuthenticateException();
                }

                $postDto = $ticketService->addPost($ticketDto, $data);
                if(isset($postDto))
                {
                    $this->sendNewPostNotification($postDto,$ticketDto);
                }
                $this->redirect($ticketService->getPostUrl($ticketId, $postDto->id));
            }
            else{
                $this->redirect(OW::getRouter()->urlForRoute('iisticketing.view_ticket',array('ticketId'=>$ticketId)));
            }
        }
        else
        {
            OW::getFeedback()->error(OW::getLanguage()->text('iisticketing', 'error_adding_post'));
            $this->redirect(OW::getRouter()->urlForRoute('iisticketing.view_ticket',array('ticketId'=>$ticketId)));
        }
    }

    private function sendNewPostNotification($postDto,$ticketDto)
    {
        $proceedPermissions=array();
        $users=array();
        $authorizationGroup= BOL_AuthorizationGroupDao::getInstance()->findByName('iisticketing');
        $action = BOL_AuthorizationActionDao::getInstance()->findAction('view_tickets',$authorizationGroup->id);
        $authorizationPermissions= BOL_AuthorizationPermissionDao::getInstance()->findByActionId($action->id);
        $ticketService = IISTICKETING_BOL_TicketService::getInstance();
        $postUrl = $ticketService->getPostUrl($postDto->ticketId, $postDto->id);
        $ticketUrl = OW::getRouter()->urlForRoute('iisticketing.view_ticket', array('ticketId' => $postDto->ticketId));
        $description = nl2br(UTIL_String::truncate($postDto->text, 300, '...'));
        $isOwner=$postDto->userId==$ticketDto->userId;
        $avatars = BOL_AvatarService::getInstance()->getDataForUserAvatars(array($postDto->userId));
        if($isOwner)
        {
            foreach ($authorizationPermissions as $authorizationPermission) {
                if (in_array($authorizationPermission->roleId, $proceedPermissions)) {
                    continue;
                }
                $userCount = (int)BOL_UserService::getInstance()->countByRoleId($authorizationPermission->roleId);
                $users = BOL_UserService::getInstance()->findListByRoleId($authorizationPermission->roleId, 0, $userCount);
                array_push($proceedPermissions, (int)$authorizationPermission->roleId);
            }
            foreach ($users as $user) {
                if ($user->getId() == $postDto->userId) {
                    continue;
                }
                $notifService = NOTIFICATIONS_BOL_Service::getInstance();
                $notification = $notifService->findNotification('ticket-post-add', (int)$ticketDto->id, $user->getId());
                if (isset($notification)) {
                    $notification->sent = 0;
                    $notification->viewed = 0;
                    $notifService->saveNotification($notification);
                } else {
                    $event = new OW_Event('notifications.add', array(
                        'pluginKey' => 'iisticketing',
                        'entityType' => 'ticket-post-add',
                        'entityId' => (int)$postDto->id,
                        'action' => 'receive-ticket-update',
                        'userId' => $user->getId(),
                        'time' => time()
                    ), array(
                        'avatar' => $avatars[$postDto->userId],
                        'string' => array(
                            'key' => 'iisticketing+ticket_notification_post',
                            'vars' => array(
                                'userName' => $avatars[$postDto->userId]['title'],
                                'userUrl' => $avatars[$postDto->userId]['url'],
                                'postUrl' => $postUrl,
                                'ticketUrl' => $ticketUrl,
                                'title' => strip_tags($ticketDto->title)
                            )
                        ),
                        'content' => $description,
                        'url' => OW::getRouter()->urlForRoute('iisticketing.view_ticket', array('ticketId' => $ticketDto->id))
                    ));
                    OW::getEventManager()->trigger($event);
                }
            }
        }else{
            $event = new OW_Event('notifications.add', array(
                'pluginKey' => 'iisticketing',
                'entityType' => 'ticket-post-add',
                'entityId' => (int)$postDto->id,
                'action' => 'receive-ticket-update',
                'userId' => $ticketDto->userId,
                'time' => time()
            ), array(
                'avatar' => $avatars[$postDto->userId],
                'string' => array(
                    'key' => 'iisticketing+ticket_notification_post',
                    'vars' => array(
                        'userName' => $avatars[$postDto->userId]['title'],
                        'userUrl' => $avatars[$postDto->userId]['url'],
                        'postUrl' => $postUrl,
                        'ticketUrl' => $ticketUrl,
                        'title' => strip_tags($ticketDto->title)
                    )
                ),
                'content' => $description,
                'url' => OW::getRouter()->urlForRoute('iisticketing.view_ticket', array('ticketId' => $ticketDto->id))
            ));
            OW::getEventManager()->trigger($event);
        }
    }

    /**
     * This action deletes thread post
     * and after execution redirects to default action
     *
     * @param array $params
     * @throws Redirect404Exception
     */
    public function deletePost( array $params )
    {
        $ticketService = IISTICKETING_BOL_TicketService::getInstance();
        if ( !isset($params['ticketId']) || !($ticketId = (int) $params['ticketId']) || !isset($params['postId']) || !($postId = (int) $params['postId']) )
        {
            throw new Redirect404Exception();
        }
        if(IISSecurityProvider::checkPluginActive('iissecurityessentials', true)) {
            if(!isset($_GET['code'])){
                throw new Redirect404Exception();
            }
            $code = $_GET['code'];
            OW::getEventManager()->trigger(new OW_Event('iissecurityessentials.on.check.request.manager',
                array('senderId' => OW::getUser()->getId(), 'code'=>$code,'activityType'=>'delete_ticket_post')));
        }

        $ticketDto = $ticketService->findTicketById($ticketId);
        $postDto = $ticketService->findTicketPostById($postId);

        $isTicketManager = OW::getUser()->isAuthorized('iisticketing', 'view_tickets')|| OW::getUser()->isAdmin();
        $isOwner=OW::getUser()->getId()==$postDto->userId;


        if ( $ticketDto && $postDto && ($isOwner|| $isTicketManager) )
        {
            $prevPostDto = $ticketService->findPreviousPost($ticketId, $postId);
            $ticketService->deletePost($postId);
            $postUrl =$ticketService->getPostUrl($ticketId, $prevPostDto->id, false);
        }
        else
        {
            $postUrl = $ticketService->getPostUrl($ticketId, $postId, false);
        }

        $this->redirect($postUrl);
    }


    /**
     * This action deletes the ticket
     * and after execution redirects to default action
     *
     * @param array $params
     * @throws Redirect404Exception
     */
    public function deleteTicket( array $params )
    {
        $ticketService = IISTICKETING_BOL_TicketService::getInstance();
        if ( !isset($params['ticketId']) || !($ticketId = (int) $params['ticketId']) )
        {
            throw new Redirect404Exception();
        }
        if(IISSecurityProvider::checkPluginActive('iissecurityessentials', true)) {
            if(!isset($_GET['code'])){
                throw new Redirect404Exception();
            }
            $code = $_GET['code'];
            OW::getEventManager()->trigger(new OW_Event('iissecurityessentials.on.check.request.manager',
                array('senderId' => OW::getUser()->getId(), 'code'=>$code,'activityType'=>'delete_ticket')));
        }

        $isTicketManager = OW::getUser()->isAuthorized('iisticketing', 'view_tickets')|| OW::getUser()->isAdmin();

        $ticketDto = $ticketService->findTicketById($ticketId);

        $userId = OW::getUser()->getId();

        $redirectUrl = OW::getRouter()->urlForRoute('iisticketing.view_tickets');

        $isOwner=OW::getUser()->getId()==$ticketDto->userId;

        if ( $ticketDto )
        {

            if ( $isTicketManager || $isOwner )
            {
                $ticketService->deleteTicket($ticketId);
            }
        }

        $this->redirect($redirectUrl);
    }



    /**
     * This action locks or unlocks the ticket
     * and after execution redirects to default action
     *
     * @param array $params
     * @throws Redirect404Exception
     */
    public function lockTicket( array $params )
    {
        $ticketService = IISTICKETING_BOL_TicketService::getInstance();
        if ( !isset($params['ticketId']) || !($ticketId = (int) $params['ticketId']) || !isset($params['page']) || !($page = (int) $params['page']) )
        {
            throw new Redirect404Exception();
        }
        if(IISSecurityProvider::checkPluginActive('iissecurityessentials', true)) {
            if(!isset($_GET['code'])){
                throw new Redirect404Exception();
            }
            $code = $_GET['code'];
            OW::getEventManager()->trigger(new OW_Event('iissecurityessentials.on.check.request.manager',
                array('senderId' => OW::getUser()->getId(), 'code'=>$code,'activityType'=>'lock_ticket')));
        }
        $isTicketManager = OW::getUser()->isAuthorized('iisticketing', 'view_tickets')|| OW::getUser()->isAdmin();

        $ticketDto = $ticketService->findTicketById($ticketId);

        if ( $ticketDto && $isTicketManager)
        {
            $ticketDto->locked = ($ticketDto->locked) ? 0 : 1;
            $ticketService->saveOrUpdateTicket($ticketDto);
        }

        $ticketUrl =  OW::getRouter()->urlForRoute('iisticketing.view_ticket',array('ticketId'=>$ticketId));

        $this->redirect($ticketUrl . "?page=$page");
    }

    /**
     * This action gets the post called by ajax request
     *
     * @param array $params
     * @throws Redirect404Exception
     */
    public function getPost( array $params )
    {
        $ticketService = IISTICKETING_BOL_TicketService::getInstance();
        if ( isset($params['postId']) && $postId = (int) $params['postId'] )
        {
            if ( OW::getRequest()->isAjax() )
            {
                $postDto = $ticketService->findPostById($postId);
                if (!$postDto){
                    exit();
                }

                $ticketDto = $ticketService->findTicketById($postDto->ticketId);
                if ( !$ticketDto ){
                    exit();
                }


                $isTicketManager = OW::getUser()->isAuthorized('iisticketing', 'view_tickets')|| OW::getUser()->isAdmin();

                $isOwner=OW::getUser()->getId()==$ticketDto->userId;


                if ( !$isOwner && !$isTicketManager )
                {
                    exit();
                }

                $postQuote = new IISTICKETING_CMP_TicketPostQuote(array(
                    'quoteId' => $postId
                ));

                echo json_encode($postQuote->render());
            }
            else
            {
                throw new Redirect404Exception();
            }
        }

        exit();
    }


    /**
     * Generates add post form.
     *
     * @param int $ticketId
     * @param string $uid
     * @return Form
     */
    private function generateAddPostForm( $ticketId, $uid )
    {
        $form = new IISTICKETING_CLASS_PostForm(
            'add-post-form',
            $uid,
            $ticketId,
            false
        );

        $form->setAction(OW::getRouter()->
        urlForRoute('iisticketing.add-post', array('ticketId' => $ticketId, 'uid' => $uid)));
        return $form;
    }

    public function ajaxDeleteAttachment()
    {
        $result = array('result' => false);

        if ( !isset($_POST['attachmentId']) || !OW::getRequest()->isAjax())
        {
            exit(json_encode($result));
        }
        if(IISSecurityProvider::checkPluginActive('iissecurityessentials', true)) {
            $code =$_POST['attachmentDeleteCode'];
            if(!isset($code)){
                throw new Redirect404Exception();
            }
            OW::getEventManager()->trigger(new OW_Event('iissecurityessentials.on.check.request.manager',
                array('senderId' => OW::getUser()->getId(), 'code'=>$code,'activityType'=>'delete_attachment')));
        }
        exit(IISTICKETING_BOL_TicketService::getInstance()->deleteAttachment((int) $_POST['attachmentId']));
    }
}

