<?php
class IISTPNETSMS_CTRL_Admin extends ADMIN_CTRL_Abstract
{
    public function index()
    {
        $language = OW::getLanguage();
        $config = OW::getConfig();
        $this->setPageHeading($language->text('iistpnetsms', 'admin_settings_title'));
        $this->setPageTitle($language->text('iistpnetsms', 'admin_settings_title'));

        $form = new Form('setting');

        $field = new TextField('user_id');
        $field->setLabel($language->text('iistpnetsms', 'user_id_label'));
        $field->setValue($config->getValue('iistpnetsms', 'user_id'));
        $field->setRequired();
        $form->addElement($field);

        $field = new TextField('password');
        $field->setLabel($language->text('iistpnetsms', 'password_label'));
        $field->setValue($config->getValue('iistpnetsms', 'password'));
        $field->setRequired();
        $form->addElement($field);

        $field = new TextField('originator');
        $field->setLabel($language->text('iistpnetsms', 'originator_label'));
        $field->setValue($config->getValue('iistpnetsms', 'originator'));
        $field->setRequired();
        $form->addElement($field);

        $field = new TextField('url');
        $field->setLabel($language->text('iistpnetsms', 'url_label'));
        $field->setValue($config->getValue('iistpnetsms', 'url'));
        $field->setRequired();
        $form->addElement($field);

        $element = new Submit('submit');
        $form->addElement($element);

        if ( OW::getRequest()->isPost() ) {
            if ($form->isValid($_POST)) {
                $data = $form->getValues();
                $config->saveConfig('iistpnetsms', 'user_id', $data['user_id']);
                $config->saveConfig('iistpnetsms', 'password', $data['password']);
                $config->saveConfig('iistpnetsms', 'originator', $data['originator']);
                $config->saveConfig('iistpnetsms', 'url', $data['url']);
                OW::getFeedback()->info($language->text('iistpnetsms', 'saved_successfully'));
            }
        }

        $this->addForm($form);
    }
}