<?php
class IISVITRIN_MCTRL_Vitrin extends OW_MobileActionController
{

    public function index($params)
    {
        $service = IISVITRIN_BOL_Service::getInstance();
        $items = $service->getItems();
        $itemsArray = array();
        foreach ($items as $item) {
            $description = explode("<!--more-->", BASE_CMP_TextFormatter::fromBBtoHtml($item->description));
            $itemsArray[] = array(
                'title'=> $item->title,
                'description' => $description[0],
                'language' => $item->language,
                'businessModel' => $item->businessModel,
                'url' => $item->url,
                'logo' => $service->getFileUrl($item->logo),
                'targetMarket' => $item->targetMarket,
                'vendor' => $item->vendor,
                'viewUrl' => OW::getRouter()->urlForRoute('iisvitrin.item', array('id' => $item->id))
            );
        }
        if(sizeof($itemsArray)==0){
            $this->assign('emptyItems', true);
        }

        $this->assign('business_model_icon',$service->getIconUrl('business_model.svg'));
        $this->assign('target_icon',$service->getIconUrl('target.svg'));
        $this->assign('developer_icon',$service->getIconUrl('developer.svg'));
        $this->assign('language_icon',$service->getIconUrl('language.svg'));

        $this->assign('items', $itemsArray);

        $cssDir = OW::getPluginManager()->getPlugin("iisvitrin")->getStaticCssUrl();
        OW::getDocument()->addStyleSheet($cssDir . "iisvitrin.css");

        OW::getDocument()->setHeading(OW::getLanguage()->text('iisvitrin', 'main_menu_item'));

        $vitrinDescription = OW::getConfig()->getValue('iisvitrin', 'description');
        if($vitrinDescription!=null && $vitrinDescription!=""){
            $this->assign('vitrinDescription', $vitrinDescription);
        }
    }

    public function item($params){
        if(!isset($params['id'])){
            $this->redirect(OW::getRouter()->urlForRoute('iisvitrin.index'));
        }
        $service = IISVITRIN_BOL_Service::getInstance();
        $item = $service->getItem($params['id']);
        if($item==null){
            $this->redirect(OW::getRouter()->urlForRoute('iisvitrin.index'));
        }
        $description = $item->description;
        $itemArray = array(
            'title'=> $item->title,
            'description' => $description,
            'language' => $item->language,
            'businessModel' => $item->businessModel,
            'targetMarket' => $item->targetMarket,
            'vendor' => $item->vendor,
            'url' => $item->url,
            'logo' => $service->getFileUrl($item->logo)
        );

        $this->assign('business_model_icon',$service->getIconUrl('business_model.svg'));
        $this->assign('target_icon',$service->getIconUrl('target.svg'));
        $this->assign('developer_icon',$service->getIconUrl('developer.svg'));
        $this->assign('language_icon',$service->getIconUrl('language.svg'));

        $this->assign('item', $itemArray);
        $this->assign('returnToVitrin', OW::getRouter()->urlForRoute('iisvitrin.index'));
        $cssDir = OW::getPluginManager()->getPlugin("iisvitrin")->getStaticCssUrl();
        OW::getDocument()->addStyleSheet($cssDir . "iisvitrin.css");

        OW::getDocument()->setHeading($item->title);
    }

}