<?php
/**
 * Copyright (c) 2016, Yaser Alimardany
 * All rights reserved.
 */

/**
 *
 *
 * @author Yaser Alimardany <yaser.alimardany@gmail.com>
 * @package ow_plugins.iiswordscorrection.bol
 * @since 1.0
 */
class IISWORDSCORRECTION_BOL_Service
{
    private static $classInstance;

    public static function getInstance()
    {
        if (self::$classInstance === null) {
            self::$classInstance = new self();
        }

        return self::$classInstance;
    }

    private function __construct()
    {
    }

    public function correct(){
        //Correct iisnews plugin words
        $this->correctNewsWords();

        //Correct groups plugin words
        $this->correctGroupsWords();

        //Correct event plugin words
        $this->correctEventWords();

        //Correct blogs plugin words
        $this->correctBlogsWords();

        //Correct video plugin words
        $this->correctVideoWords();

        //Correct forum plugin words
        $this->correctForumWords();

        //Correct photo plugin words
        $this->correctPhotoWords();

        //Correct newsfeed plugin words
        $this->correctNewsFeedWords();

        //Correct component setting words (ex: User about me field)
        $this->correctComponentSettingWords();

        //Correct all tag words
        $this->correctTagsWords();

        //Correct users realname words
        $this->correctUsersRealName();
    }

    public function correctTagsWords(){
        if(!$this->tableExist('base_tag')){
            return;
        }

        //Correct location
        $this->correctWord('base_tag', 'label', 'ي', 'ی');
        $this->correctWord('base_tag', 'label', 'ك', 'ک');
    }

    public function correctNewsFeedWords(){
        if(!$this->tableExist('newsfeed_status')){
            return;
        }

        //Correct status
        $this->correctWord('newsfeed_status', 'status', 'ي', 'ی');
        $this->correctWord('newsfeed_status', 'status', 'ك', 'ک');
    }

    public function correctComponentSettingWords(){
        if(!$this->tableExist('base_component_entity_setting')){
            return;
        }

        //Correct value
        $this->correctWord('base_component_entity_setting', 'value', 'ي', 'ی');
        $this->correctWord('base_component_entity_setting', 'value', 'ك', 'ک');
    }

    public function correctPhotoWords(){
        if(!$this->tableExist('photo') || !$this->tableExist('photo_album')){
            return;
        }

        //Correct description of photo
        $this->correctWord('photo', 'description', 'ي', 'ی');
        $this->correctWord('photo', 'description', 'ك', 'ک');

        //Correct name of album
        $this->correctWord('photo_album', 'name', 'ي', 'ی');
        $this->correctWord('photo_album', 'name', 'ك', 'ک');

        //Correct description of album
        $this->correctWord('photo_album', 'description', 'ي', 'ی');
        $this->correctWord('photo_album', 'description', 'ك', 'ک');
    }

    public function correctForumWords(){
        if(!$this->tableExist('forum_post') || !$this->tableExist('forum_topic')){
            return;
        }

        //Correct text of post
        $this->correctWord('forum_post', 'text', 'ي', 'ی');
        $this->correctWord('forum_post', 'text', 'ك', 'ک');

        //Correct title of topic
        $this->correctWord('forum_topic', 'title', 'ي', 'ی');
        $this->correctWord('forum_topic', 'title', 'ك', 'ک');
    }

    public function correctVideoWords(){
        if(!$this->tableExist('video_clip')){
            return;
        }

        //Correct title
        $this->correctWord('video_clip', 'title', 'ي', 'ی');
        $this->correctWord('video_clip', 'title', 'ك', 'ک');

        //Correct description
        $this->correctWord('video_clip', 'description', 'ي', 'ی');
        $this->correctWord('video_clip', 'description', 'ك', 'ک');
    }

    public function correctEventWords(){
        if(!$this->tableExist('event_item')){
            return;
        }

        //Correct title
        $this->correctWord('event_item', 'title', 'ي', 'ی');
        $this->correctWord('event_item', 'title', 'ك', 'ک');

        //Correct description
        $this->correctWord('event_item', 'description', 'ي', 'ی');
        $this->correctWord('event_item', 'description', 'ك', 'ک');

        //Correct location
        $this->correctWord('event_item', 'location', 'ي', 'ی');
        $this->correctWord('event_item', 'location', 'ك', 'ک');
    }

    public function correctGroupsWords(){
        if(!$this->tableExist('groups_group')){
            return;
        }

        //Correct title
        $this->correctWord('groups_group', 'title', 'ي', 'ی');
        $this->correctWord('groups_group', 'title', 'ك', 'ک');

        //Correct description
        $this->correctWord('groups_group', 'description', 'ي', 'ی');
        $this->correctWord('groups_group', 'description', 'ك', 'ک');
    }

    public function correctBlogsWords(){
        if(!$this->tableExist('blogs_post')){
            return;
        }

        //Correct title
        $this->correctWord('blogs_post', 'title', 'ي', 'ی');
        $this->correctWord('blogs_post', 'title', 'ك', 'ک');

        //Correct post
        $this->correctWord('blogs_post', 'post', 'ي', 'ی');
        $this->correctWord('blogs_post', 'post', 'ك', 'ک');
    }

    public function correctNewsWords(){
        if(!$this->tableExist('iisnews_entry')){
            return;
        }

        //Correct title
        $this->correctWord('iisnews_entry', 'title', 'ي', 'ی');
        $this->correctWord('iisnews_entry', 'title', 'ك', 'ک');

        //Correct entry
        $this->correctWord('iisnews_entry', 'entry', 'ي', 'ی');
        $this->correctWord('iisnews_entry', 'entry', 'ك', 'ک');
    }

    public function correctUsersRealName(){
        if(!$this->tableExist('base_question_data')){
            return;
        }
        $whereClause = ' where `questionName`=:name';
        $params = array('name'=>'realname');
        //Correct title
        $this->correctWord('base_question_data', 'textValue', 'ي', 'ی',$whereClause,$params);
        $this->correctWord('base_question_data', 'textValue', 'ك', 'ک',$whereClause,$params);
    }

    public function correctWord($tableName, $columnName, $oldWord, $newWord,$whereClause=null,$params=null){
        if(isset($whereClause) && isset($params)) {
            $query = "update " . OW_DB_PREFIX . $tableName . " set " . $columnName . " = REPLACE(" . $columnName . ",'" . $oldWord . "','" . $newWord . "') " . $whereClause;
            OW::getDbo()->query($query,$params);
        }else {
            $query = "update " . OW_DB_PREFIX . $tableName . " set " . $columnName . " = REPLACE(" . $columnName . ",'" . $oldWord . "','" . $newWord . "')";
            OW::getDbo()->query($query);
        }
    }

    /**
     * @param string $text
     * @return string
     */
    public function correctWordString($text)
    {
        $text = str_replace('ي', 'ی',$text);
        $text = str_replace('ك', 'ک',$text);
        return $text;
    }

    public function tableExist($tableName){
        $table = OW::getDbo()->queryForRow('show tables like :tableName', array('tableName' => OW_DB_PREFIX . $tableName));
        if (empty($table)) {
            return false;
        }

        return true;
    }
}