<?php
require_once dirname(__FILE__) . DS . 'lib.php';

$dbo = Updater::getDbo();

$source = new NEWSFEED_TableList('source', $dbo);

$source->addTable('action');
$source->addTable('action_feed');
$source->changePrefix('newsfeed_tmp_');

$dist = new NEWSFEED_TableList('dist', $dbo);

$dist->createTable('action', "CREATE TABLE `%action%` (
  `id` int(11) NOT NULL auto_increment,
  `entityId` int(11) NOT NULL,
  `entityType` varchar(100) NOT NULL,
  `pluginKey` varchar(100) NOT NULL,
  `data` longtext NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `entity` (`entityType`,`entityId`)
) DEFAULT CHARSET=utf8;");

$dist->createTable('action_feed', "CREATE TABLE `%action_feed%` (
  `id` int(11) NOT NULL auto_increment,
  `feedType` varchar(100) NOT NULL,
  `feedId` int(11) NOT NULL,
  `activityId` int(11) NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `feedId` (`feedType`,`feedId`,`activityId`),
  KEY `actionId` (`activityId`)
) DEFAULT CHARSET=utf8;");

$dist->createTable('activity', "CREATE TABLE `%activity%` (
  `id` int(11) NOT NULL auto_increment,
  `activityType` varchar(100) NOT NULL,
  `activityId` int(11) NOT NULL,
  `userId` int(11) NOT NULL,
  `data` text NOT NULL,
  `actionId` int(11) NOT NULL,
  `timeStamp` int(11) NOT NULL,
  `privacy` varchar(100) NOT NULL,
  `visibility` int(11) NOT NULL,
  `status` varchar(100) NOT NULL default 'active',
  UNIQUE KEY `id` (`id`),
  UNIQUE KEY `activityId` (`activityId`,`activityType`,`actionId`),
  KEY `actionId` (`actionId`),
  KEY `userId` (`userId`),
  KEY `activityType` ( `activityType`),
  KEY `timeStamp` (`timeStamp`)
) DEFAULT CHARSET=utf8;");

$dist->addTable('follow');
$dist->query("ALTER TABLE `%follow%` ADD `permission` VARCHAR( 255 ) NOT NULL DEFAULT 'everybody'");

$r = $source->mysqlQuery("SELECT * FROM `%action%`");
while ( $sAction = mysql_fetch_assoc($r) )
{
    $dActionId = $dist->insertRow('action', array(
        'entityType' => $sAction['entityType'],
        'entityId' => $sAction['entityId'],
        'pluginKey' => $sAction['pluginKey'],
        'data' => $sAction['data']
    ));

    $dActivityCreateId = $dist->insertRow('activity', array(
        'actionId' => $dActionId,
        'activityType' => 'create',
        'activityId' => $sAction['userId'],
        'userId' => $sAction['userId'],
        'data' => json_encode(array()),
        'timeStamp' => $sAction['createTime'],
        'privacy' => 'everybody',
        'visibility' => $sAction['privacy'],
        'status' => $sAction['status']
    ));

    $dActivitySubscribeId = $dist->insertRow('activity', array(
        'actionId' => $dActionId,
        'activityType' => 'subscribe',
        'activityId' => $sAction['userId'],
        'userId' => $sAction['userId'],
        'data' => json_encode(array()),
        'timeStamp' => $sAction['updateTime'],
        'privacy' => 'everybody',
        'visibility' => $sAction['privacy'],
        'status' => $sAction['status']
    ));

    $actionFeeds = $source->queryForList('SELECT * FROM `%action_feed%` WHERE actionId=:a', array('a' => $sAction['id']));

    foreach ( $actionFeeds as $feed )
    {
        $dist->insertRow('action_feed', array(
            'feedType' => $feed['feedType'],
            'feedId' => $feed['feedId'],
            'activityId' => $dActivityCreateId
        ));

        $dist->insertRow('action_feed', array(
            'feedType' => $feed['feedType'],
            'feedId' => $feed['feedId'],
            'activityId' => $dActivitySubscribeId
        ));
    }
}

function update3500CronJob()
{
    $friends = OW::getEventManager()->call('plugin.friends.find_all_active_friendships');

    foreach ( $friends as $f )
    {
        $this->service->addFollow((int) $f->userId, 'user', (int) $f->friendId, 'friends_only');
        $this->service->addFollow((int) $f->friendId, 'user', (int) $f->userId, 'friends_only');
    }

    return true;
}

update3500CronJob();

$source->dropTables();

Updater::getConfigService()->addConfig('newsfeed', 'disabled_action_types', '');

$updateDir = dirname(__FILE__) . DS;
Updater::getLanguageService()->importPrefixFromZip($updateDir . 'langs.zip', 'newsfeed');

$newsfeed = OW::getPluginManager()->getPlugin('newsfeed');

$staticDir = OW_DIR_STATIC_PLUGIN . $newsfeed->getModuleName() . DS;
$staticJsDir = $staticDir  . 'js' . DS;

OW::getStorage()->copyFile($newsfeed->getStaticJsDir() . 'newsfeed.js', $staticJsDir . 'newsfeed.js', true);