<?php
$dbPrefix = OW_DB_PREFIX;

try
{
    $sql = " CREATE TABLE IF NOT EXISTS `{$dbPrefix}newsfeed_action_set` (
      `id` int(11) NOT NULL AUTO_INCREMENT,
      `actionId` int(11) NOT NULL,
      `userId` int(11) NOT NULL,
      `timestamp` int(11) NOT NULL,
      PRIMARY KEY (`id`),
      UNIQUE KEY `actionId` (`actionId`,`userId`)
    ) DEFAULT CHARSET=utf8 AUTO_INCREMENT=0 ;";

    Updater::getDbo()->query($sql);
}
catch ( Exception $ex )
{
    $errors[] = $ex;
}

$preference = BOL_PreferenceService::getInstance()->findPreference('newsfeed_generate_action_set_timestamp');

if ( empty($preference) )
{
    $preference = new BOL_Preference();
}

$preference->key = 'newsfeed_generate_action_set_timestamp';
$preference->sectionName = 'general';
$preference->defaultValue = 0;
$preference->sortOrder = 10000;

BOL_PreferenceService::getInstance()->savePreference($preference);

$updateDir = dirname(__FILE__) . DS;
Updater::getLanguageService()->importPrefixFromZip($updateDir . 'langs.zip', 'newsfeed');
