<?php
/**
 * @author Issa Annamoradnejad <i.moradnejad@gmail.com>
 * @package notifications.bol
 * @since 2.0
 */
class NOTIFICATIONS_BOL_NotificationDataDao extends OW_BaseDao
{

    /**
     * Constructor.
     *
     */
    protected function __construct()
    {
        parent::__construct();
    }
    /**
     * Singleton instance.
     *
     * @var NOTIFICATIONS_BOL_NotificationDataDao
     */
    private static $classInstance;

    /**
     * Returns an instance of class (singleton pattern implementation).
     *
     * @return NOTIFICATIONS_BOL_NotificationDataDao
     */
    public static function getInstance()
    {
        if ( self::$classInstance === null )
        {
            self::$classInstance = new self();
        }

        return self::$classInstance;
    }

    /**
     * @see OW_BaseDao::getDtoClassName()
     *
     */
    public function getDtoClassName()
    {
        return 'NOTIFICATIONS_BOL_NotificationData';
    }

    /**
     * @see OW_BaseDao::getTableName()
     *
     */
    public function getTableName()
    {
        return OW_DB_PREFIX . 'notifications_notification_data';
    }

    /***
     * @param string $string
     * @return mixed
     */
    public function findIdByDataString($string )
    {
        $example = new OW_Example();
        $example->andFieldEqual('data', $string);
        return $this->findIdByExample($example);
    }

    /***
     * @param $id
     * @return string
     */
    public function findDataById( $id )
    {
        $obj = $this->findById($id);
        if ($obj == null) {
            return null;
        }
        return $obj->getData();
    }

    /***
     * @param $string
     */
    public function insert($string ){
        $newData = new NOTIFICATIONS_BOL_NotificationData();
        $newData->setData($string);
        $this->save($newData);
        return $newData->id;
    }

    /***
     * @param $data
     * @return false|string
     */
    public function convertDataToString($data){
        $homeUrlCorrectorEvent = OW::getEventManager()->trigger(new OW_Event(IISEventManager::ON_BEFORE_NOTIFICATION_STRING_WRITE, array('data' => $data)));
        if(isset($homeUrlCorrectorEvent->getData()['data'])){
            $data = $homeUrlCorrectorEvent->getData()['data'];
        }
        if (isset($data['cache'])) {
            unset($data['cache']);
        }
        return json_encode($data);
    }

    /***
     * @param $string
     * @return mixed|null
     */
    public function convertStringToData($string){
        $homeUrlCorrectorEvent = OW::getEventManager()->trigger(new OW_Event(IISEventManager::ON_AFTER_NOTIFICATION_STRING_READ, array('data' => $string)));
        if(isset($homeUrlCorrectorEvent->getData()['data'])){
            $string = $homeUrlCorrectorEvent->getData()['data'];
        }

        return empty($string) ? null : json_decode($string, true);
    }
}