<?php
/**
 * @package ow_system_plugins.base.components
 * @since 1.0
 */
class BASE_CMP_Rate extends OW_Component
{

    public function __construct( $pluginKey, $entityType, $entityId, $ownerId )
    {
        parent::__construct();
        if(OW::getPluginManager()->isPluginActive('iiswidgetplus') && OW::getConfig()->getValue('iiswidgetplus', 'displayRateWidget')==2 && !OW::getUser()->isAuthenticated()) {
            $this->assign('display', false);
            return;
        }
        else
            $this->assign('display', true);
        $service = BOL_RateService::getInstance();

        $maxRate = $service->getConfig(BOL_RateService::CONFIG_MAX_RATE);

        $cmpId = IISSecurityProvider::generateUniqueId();

        $entityId = (int) $entityId;
        $entityType = trim($entityType);
        $ownerId = (int) $ownerId;

        if ( OW::getUser()->isAuthenticated() )
        {
            $userRateItem = $service->findRate($entityId, $entityType, OW::getUser()->getId());

            if ( $userRateItem !== null )
            {
                $userRate = $userRateItem->getScore();
            }
            else
            {
                $userRate = null;
            }
        }
        else
        {
            $userRate = null;
        }

        $this->assign('maxRate', $maxRate);
        $this->addComponent('totalScore', new BASE_CMP_TotalScore($entityId, $entityType, $maxRate));
        $this->assign('cmpId', $cmpId);

        $jsParamsArray = array(
            'cmpId' => $cmpId,
            'userRate' => $userRate,
            'entityId' => $entityId,
            'entityType' => $entityType,
            'itemsCount' => $maxRate,
            'respondUrl' => OW::getRouter()->urlFor('BASE_CTRL_Rate', 'updateRate'),
            'ownerId' => $ownerId
        );
        $code='';
        $iisSecuritymanagerEvent= OW::getEventManager()->trigger(new OW_Event('iissecurityessentials.on.generate.request.manager',
            array('senderId'=>Ow::getUser()->getId(),'receiverId'=>$entityId,'isPermanent'=>true,'activityType'=>'update_rate')));
        if(isset($iisSecuritymanagerEvent->getData()['code'])){
            $code = $iisSecuritymanagerEvent->getData()['code'];
            $jsParamsArray['respondUrl'] = OW::getRequest()->buildUrlQueryString(OW::getRouter()->urlFor('BASE_CTRL_Rate', 'updateRate'),array('code' =>$code));
        }
        OW::getDocument()->addOnloadScript("var rate$cmpId = new OwRate(" . json_encode($jsParamsArray) . "); rate$cmpId.init();");
    }
}