<?php
/**
 * Mobile console profile page
 *
 * @author Egor Bulgakov <egor.bulgakov@gmail.com>
 * @package ow.ow_system_plugins.base.mobile.components
 * @since 1.6.0
 */
class BASE_MCMP_ConsoleProfilePage extends OW_MobileComponent
{
    /**
     * Constructor.
     */
    public function __construct()
    {
        parent::__construct();

        if ( !OW::getUser()->isAuthenticated() )
        {
            $this->setVisible(false);
        }
    }

    public function onBeforeRender()
    {
        parent::onBeforeRender();

        $userId = OW::getUser()->getId();
        $userService = BOL_UserService::getInstance();

        $this->assign('username', $userService->getDisplayName($userId));
        $this->assign('url', $userService->getUserUrl($userId));
        $avatars = BOL_AvatarService::getInstance()->getDataForUserAvatars(array($userId));
        $this->assign('avatarUrl', $avatars[$userId]['src']);

        $script = '$(".owm_sidebar_profile_logout").click(function(){
            document.location.href = '.json_encode(OW::getRouter()->urlForRoute('base_sign_out')).';
        });';
        OW::getDocument()->addOnloadScript($script);
        $event = new BASE_CLASS_EventCollector('iis.on.mobile.add.item');

        $resultsEvent =  OW::getEventManager()->trigger($event);
        //$resultsEvent = OW::getEventManager()->trigger(new OW_Event(IISEventManager::ON_MOBILE_ADD_ITEM, array('user'=>OW::getUser())));
        if(sizeof($resultsEvent->getData())>0) {
            $this->assign('isParent',true);
            $addItems = $resultsEvent->getData();
            $parentalLinks = array();
            foreach ( $addItems as $addItem )
            {
                if ( !empty($addItem['label']) && !empty($addItem['url']) )
                {
                    $parentalLinks[]=array(
                        'label' => $addItem['label'],
                        'url' => $addItem['url']);
                }
            }
            $this->assign('parentalLinks',$parentalLinks);
        }
    }
}