<?php
class iisblockingipTest extends IISUnitTestUtilites
{
    public function setUp()
    {
        parent::setUp();
    }

    /**
     * Test of blocking users by ip in iisblockingip plugin
     */
    public function testBlocking()
    {
        $oldValue = OW::getConfig()->getValue('iisblockingip', IISBLOCKINGIP_BOL_Service::TRY_COUNT_BLOCK);
        OW::getConfig()->saveConfig('iisblockingip', IISBLOCKINGIP_BOL_Service::TRY_COUNT_BLOCK, 3);

        $service = IISBLOCKINGIP_BOL_Service::getInstance();
        $service->deleteBlockCurrentIp();

        self::assertEquals(0, $service->getUserTryCount());
        self::assertEquals(false, $service->isLocked());

        $service->bruteforceTrack();
        self::assertEquals(1, $service->getUserTryCount());
        self::assertEquals(false, $service->isLocked());

        $service->bruteforceTrack();
        self::assertEquals(2, $service->getUserTryCount());
        self::assertEquals(false, $service->isLocked());

        $service->bruteforceTrack();
        self::assertEquals(3, $service->getUserTryCount());
        self::assertEquals(false, $service->isLocked());

        $service->bruteforceTrack();
        self::assertEquals(4, $service->getUserTryCount());
        self::assertEquals(true, $service->isLocked());

        $service->deleteBlockCurrentIp();
        self::assertEquals(0, $service->getUserTryCount());
        self::assertEquals(false, $service->isLocked());

        OW::getConfig()->saveConfig('iisblockingip', IISBLOCKINGIP_BOL_Service::TRY_COUNT_BLOCK, $oldValue);
    }
    public function tearDown()
    {
        parent::tearDown(); // TODO: Change the autogenerated stub
    }
}