<?php
class iisuserloginTest extends IISUnitTestUtilites
{
    public function setUp()
    {
        parent::setUp();
        $accountType = BOL_QuestionService::getInstance()->getDefaultAccountType()->name;
        IISSecurityProvider::createUser('iisuserlogintest', 'iisuserlogintest@test.com', '12345678', '1987/3/21', '1',$accountType,'c0de');
    }

    /**
     * Test of iisevaluation plugin
     */
    public function testLogin()
    {
        $service = IISUSERLOGIN_BOL_Service::getInstance();
        $user = BOL_UserService::getInstance()->findByUsername('iisuserlogintest');
        $service->addLoginDetails($user->getId(), false);
        $userLoginDetails = $service->getUserLoginDetails($user->getId(), false);
        self::assertEquals(1, sizeof($userLoginDetails));

        $service->addLoginDetails($user->getId(), false);
        $userLoginDetails = $service->getUserLoginDetails($user->getId(), false);
        self::assertEquals(2, sizeof($userLoginDetails));

        $service->deleteUserLoginDetails($user->getId(), false);
        $userLoginDetails = $service->getUserLoginDetails($user->getId(), false);
        self::assertEquals(0, sizeof($userLoginDetails));
    }

    public function tearDown()
    {
        IISSecurityProvider::deleteUser('iisuserlogintest');
    }
}