package ir.iiscenter.shub;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.widget.Toast;

/**
 * Created by taesiri on 11/6/16.
 */

public class ConnectivityReceiver extends BroadcastReceiver {

    private boolean isRegistered;

    @Override
    public void onReceive(final Context context, final Intent intent) {
        if (!InternetConnection.checkNetworkConnection(context)) {
            Toast.makeText(context, context.getResources().getString(R.string.push_to_reload), Toast.LENGTH_LONG).show();
        } else {
            //TODO: reload page. (but if reload every time, may be url of this event conflicted with load of webview when user reloading event happened).
        }
    }

    // Suggested here: http://stackoverflow.com/a/29836639/846210

    /**
     * register receiver
     *
     * @param context - Context
     * @param filter  - Intent Filter
     * @return see Context.registerReceiver(BroadcastReceiver,IntentFilter)
     */
    public Intent register(Context context, IntentFilter filter) {
        if (getIsRegistered())
            return null;
        setIsRegistered(true);
        return context.registerReceiver(this, filter);
    }

    /**
     * unregister received
     *
     * @param context - context
     * @return true if was registered else false
     */
    public boolean unregister(Context context) {
        if (getIsRegistered()) {
            context.unregisterReceiver(this);
            setIsRegistered(false);
            return true;
        }
        return false;
    }

    /**
     * @return Returns true if ConnectivityReceiver is registered, else returns false
     */
    private boolean getIsRegistered() {
        return isRegistered;
    }

    /**
     * @param value boolean value to be set for isRegistered
     */
    private void setIsRegistered(boolean value) {
        isRegistered = value;
    }

}