package ir.iiscenter.shub;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.webkit.CookieManager;

import org.json.JSONArray;
import org.json.JSONObject;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

import javax.net.ssl.HttpsURLConnection;

/**
 * Created by Alimardani on 10/15/2016.
 */

public class InformationReceiver {

    /***
     * Fetch all information like menu items, language items and current user information.
     * @param context
     * @return
     */
    public static Information getInformation(Context context) {
        StringBuilder result = new StringBuilder();
        HttpURLConnection urlConnection = null;
        Information information = null;
        try {
            String informationUrl = Config.getInstance(context).getInformationUrl() + "?versionCode=" + BuildConfig.VERSION_CODE;
            URL url = new URL(informationUrl);

            if (Uri.parse(Uri.decode(informationUrl)).getScheme().equals("https")) {
                //start bypass SSL certificate validation in Android app
                /*TrustManager[] trustAllCerts = new TrustManager[] {new X509TrustManager() {
                    public java.security.cert.X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }
                    public void checkClientTrusted(X509Certificate[] certs, String authType) {
                    }
                    public void checkServerTrusted(X509Certificate[] certs, String authType) {
                    }
                }
                };

                // Install the all-trusting trust manager
                SSLContext sc = SSLContext.getInstance("SSL");
                sc.init(null, trustAllCerts, new java.security.SecureRandom());
                HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());

                // Create all-trusting host name verifier
                HostnameVerifier allHostsValid = new HostnameVerifier() {
                    public boolean verify(String hostname, SSLSession session) {
                        return true;
                    }
                };

                // Install the all-trusting host verifier
                HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);*/
                //end bypass SSL certificate validation in Android app

                urlConnection = (HttpsURLConnection) url.openConnection();
            } else if (Uri.parse(Uri.decode(informationUrl)).getScheme().equals("http")) {
                urlConnection = (HttpURLConnection) url.openConnection();
            }

            if (urlConnection != null) {

                urlConnection.setRequestMethod("GET");
                urlConnection.setUseCaches(false);
                urlConnection.setAllowUserInteraction(false);
                urlConnection.setConnectTimeout(Config.getInstance(context).getInformationReceiverTimeout());
                urlConnection.setReadTimeout(Config.getInstance(context).getInformationReceiverTimeout());
                // Set cookies in requests

                CookieManager cookieManager = CookieManager.getInstance();
                String cookie = cookieManager.getCookie(Config.getInstance(context).getHomeUrl());
                if (cookie != null) {
                    urlConnection.setRequestProperty("Cookie", cookie);
                }
                urlConnection.setRequestProperty("user-agent", Config.getInstance(context).getUserAgentDescription());
                urlConnection.connect();
                BufferedReader in = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));

                String line;
                while ((line = in.readLine()) != null) {
                    result.append(line);
                }
                // Get cookies from responses and save into the cookie manager
                List cookieList = urlConnection.getHeaderFields().get("Set-Cookie");
                if (result != null) {
                    JSONObject object = new JSONObject(result.toString());

                    ArrayList<MyMenuItem> mainMenuItems = new ArrayList<>();
                    if (object.has("menuTypeMainItems")) {
                        JSONArray JasonMainMenuItems = (JSONArray) object.get("menuTypeMainItems");
                        for (int i = 0; i < JasonMainMenuItems.length(); i++) {
                            JSONObject data = (JSONObject) JasonMainMenuItems.get(i);
                            mainMenuItems.add(new MyMenuItem(data.getString("label"), data.getString("url")));
                        }
                    }

                    ArrayList<MyMenuItem> footerMenuItems = new ArrayList<>();
                    if (object.has("menuTypeBottomItems")) {
                        JSONArray JsonMenuTypeBottomItems = (JSONArray) object.get("menuTypeBottomItems");
                        for (int i = 0; i < JsonMenuTypeBottomItems.length(); i++) {
                            JSONObject data = (JSONObject) JsonMenuTypeBottomItems.get(i);
                            footerMenuItems.add(new MyMenuItem(data.getString("label"), data.getString("url")));
                        }
                    }

                    ArrayList<MyMenuItem> languageMenuItems = new ArrayList<>();
                    if (object.has("languageItems")) {
                        JSONArray JsonLanguageItems = (JSONArray) object.get("languageItems");
                        for (int i = 0; i < JsonLanguageItems.length(); i++) {
                            JSONObject data = (JSONObject) JsonLanguageItems.get(i);
                            String tag = UTIL.getMainTagOfLocale(data.getString("tag"));
                            MyMenuItem menuItem = new MyMenuItem(data.getString("label"), Config.getInstance(context).getHomeUrl() + "?language_id=" + data.getString("id"));
                            if (data.has("isRtl")) {
                                if (data.getInt("isRtl") == 0) {
                                    menuItem.setRtl(false);
                                } else {
                                    menuItem.setRtl(true);
                                }
                            }
                            menuItem.setTag(tag);
                            menuItem.setLanguageId(data.getString("id"));
                            menuItem.isCurrent(data.getBoolean("is_current"));
                            languageMenuItems.add(menuItem);
                        }
                    }

                    User user = null;
                    if (object.has("userInformation") && object.get("userInformation") instanceof JSONObject) {
                        JSONObject userInformation = (JSONObject) object.get("userInformation");
                        if (userInformation.has("name")) {
                            String userName = userInformation.getString("name");
                            String userEmail = userInformation.getString("email");
                            Bitmap userAvatar = getBitmapFromURL(userInformation.getString("avatarUrl"));
                            String userProfileUrl = userInformation.getString("profileUrl");
                            user = new User(userName, userEmail, userAvatar, userProfileUrl);
                        }
                    }

                    VersionInformation versionInformation = new VersionInformation();
                    if (object.has("androidInformation") && object.get("androidInformation") instanceof JSONObject) {
                        JSONObject androidInformation = (JSONObject) object.get("androidInformation");
                        if (androidInformation.has("versionName") && !androidInformation.getString("versionName").equals("")) {
                            boolean isDeprecated = false;
                            if (androidInformation.getString("isDeprecated").equals("true")) {
                                isDeprecated = true;
                            }
                            versionInformation.setCurrentDeprecated(isDeprecated);
                            versionInformation.setLastVersionCode(androidInformation.getInt("versionCode"));
                            versionInformation.setLastVersionUrl(androidInformation.getString("lastVersionUrl"));
                            versionInformation.setLastVersionName(androidInformation.getString("versionName"));
                        }
                    }

                    information = new Information(mainMenuItems, footerMenuItems, languageMenuItems, user, versionInformation);
                }

            }
        } catch (Exception e) {
            return information;
        } finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }


        return information;
    }

    /***
     * Download and convert avatar image to bitmap
     * @param strURL
     * @return
     */
    public static Bitmap getBitmapFromURL(String strURL) {
        try {
            URL url = new URL(strURL);
            HttpURLConnection connection = (HttpURLConnection) url.openConnection();
            connection.setDoInput(true);
            connection.connect();
            InputStream input = connection.getInputStream();
            Bitmap myBitmap = BitmapFactory.decodeStream(input);
            return UTIL.getRoundedCornerBitmap(myBitmap, 40);
        } catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

}