package ir.iiscenter.shub;

import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.support.v4.app.NotificationCompat;
import android.support.v4.app.TaskStackBuilder;

import com.google.firebase.messaging.FirebaseMessagingService;
import com.google.firebase.messaging.RemoteMessage;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;

import org.json.JSONObject;

import java.lang.reflect.Type;
import java.util.ArrayList;


public class MyFirebaseMessagingService extends FirebaseMessagingService {

    private final static int NOTIFICATION_ID = 12345678;

    @Override
    public void onMessageReceived(RemoteMessage remoteMessage) {

        String title = null;
        String description = null;
        String avatarUrl = null;
        String url = null;

        try {
            JSONObject object = new JSONObject(remoteMessage.getData());

            title = object.get("title").toString();
            description = object.get("description").toString();
            avatarUrl = object.get("avatarUrl").toString();
            url = object.get("url").toString();

        } catch (Exception e) {
            e.printStackTrace();
        }

        if (title != null && description != null && !title.equals("check-user-activity")) {
            ArrayList<String> messageList = getAllNotificationsFromSharedPreferences();
            NotificationCompat.Builder mBuilder =
                    new NotificationCompat.Builder(this)
                            .setSmallIcon(R.mipmap.ic_launcher_raw)
                            .setContentTitle(title);

            if (messageList.size() == 0) {
                mBuilder.setStyle(new NotificationCompat.BigTextStyle().bigText(description))
                        .setContentText(description);

                if (avatarUrl != null) {
                    Bitmap bitmap = InformationReceiver.getBitmapFromURL(avatarUrl);
                    mBuilder.setLargeIcon(bitmap);
                }
            } else {
                NotificationCompat.InboxStyle inboxStyle = new NotificationCompat.InboxStyle();
                inboxStyle.addLine(description);
                for (String message : messageList) {
                    inboxStyle.addLine(message);
                }
                mBuilder.setStyle(inboxStyle);
                mBuilder.setContentText((messageList.size() + 1) + " " + getString(R.string.new_message));
                Bitmap largeIcon = BitmapFactory.decodeResource(getResources(), R.mipmap.ic_launcher_raw);
                mBuilder.setLargeIcon(largeIcon);
            }

            addNotificationToSharedPreferences(description);

            // Creates an explicit intent for an Activity in your app
            Intent resultIntent = new Intent(this, MainActivity.class);

            resultIntent.putExtra("href", url);
            resultIntent.putExtra("fromNotification", "true");

            // The stack builder object will contain an artificial back stack for the
            // started Activity.
            // This ensures that navigating backward from the Activity leads out of
            // your application to the Home screen.
            TaskStackBuilder stackBuilder = TaskStackBuilder.create(this);

            // Adds the back stack for the Intent (but not the Intent itself)
            stackBuilder.addParentStack(MainActivity.class);

            // Adds the Intent that starts the Activity to the top of the stack
            stackBuilder.addNextIntent(resultIntent);
            PendingIntent resultPendingIntent = stackBuilder.getPendingIntent(0, PendingIntent.FLAG_UPDATE_CURRENT);
            mBuilder.setContentIntent(resultPendingIntent);
            mBuilder.setAutoCancel(true);

            NotificationManager mNotificationManager = (NotificationManager) getSystemService(Context.NOTIFICATION_SERVICE);

            // mId allows you to update the notification later on.
            mNotificationManager.notify(NOTIFICATION_ID, mBuilder.build());
        }
    }

    //********Helper classes*******

    private void addNotificationToSharedPreferences(String message) {
        SharedPreferences sharedPreferences = getSharedPreferences("notifications", Context.MODE_PRIVATE);
        ArrayList<String> strings = getAllNotificationsFromSharedPreferences();
        strings.add(0, message);
        Gson gson = new Gson();
        sharedPreferences.edit().putString("messageSet", gson.toJson(strings)).apply();
    }

    private ArrayList<String> getAllNotificationsFromSharedPreferences() {
        SharedPreferences sharedPreferences = getSharedPreferences("notifications", Context.MODE_PRIVATE);
        String string = sharedPreferences.getString("messageSet", null);
        Gson gson = new Gson();
        Type type = new TypeToken<ArrayList<String>>() {
        }.getType();
        ArrayList<String> strings = gson.fromJson(string, type);
        if (strings == null) {
            return new ArrayList<>();
        } else
            return strings;
    }
}
