package ir.iiscenter.shub;


import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.webkit.MimeTypeMap;

/**
 * Created by taesiri on 11/7/16.
 */

class NavigationHelper {

    private static final String TAG = NavigationHelper.class.getName();

    private static boolean isInternalUri(Uri uri, Context context) {
        String scheme = uri.getScheme();
        if (scheme == null || (!scheme.equalsIgnoreCase("http") && !scheme.equalsIgnoreCase("https"))) {
            return false;
        }

        String host = uri.getHost();
        String initialHost = Config.getInstance(context).getInitialHost();

        if(host != null &&  host.equals(initialHost)){
            return true;
        }

        return host != null && host.endsWith("." + initialHost) && Config.getInstance(context).isSupportSubDomain();

    }

    static boolean checkUrlForOverriding(final String url, final boolean noAction, MainActivity mainActivity) {
        //check downloadable files
        String extension = MimeTypeMap.getFileExtensionFromUrl(url);
        if (extension != null && !extension.equals("") && UTIL.isInArrayOfExtensions(extension)) {
            UTIL.downloadFile(url, mainActivity);
            return true;
        }

        // return if loading from local assets
        if (url.startsWith("file:///android_asset/")) return false;

        Uri uri = Uri.parse(url);

        if (!NavigationHelper.isInternalUri(uri, mainActivity)){
            if (noAction) return true;

            // launch browser
            Intent intent = new Intent(Intent.ACTION_VIEW, uri);
            try {
                mainActivity.startActivity(intent);
            } catch (ActivityNotFoundException e) {
                //Log.e(TAG, e.getMessage(), e);
            }
            return true;
        }
        return false;
    }
}
