package ir.iiscenter.shub;

import android.app.DownloadManager;
import android.content.Context;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.net.Uri;
import android.os.Environment;
import android.provider.MediaStore;
import android.text.Spannable;
import android.text.SpannableString;
import android.webkit.MimeTypeMap;
import android.widget.TextView;
import android.widget.Toast;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;

/**
 * Created by Alimardani on 10/29/2016.
 */

public class UTIL {

    /***
     * Convert string to custom font
     *
     * @param title
     * @param font
     * @return SpannableString
     */
    public static SpannableString convertToCustomFont(CharSequence title, Typeface font) {
        SpannableString mNewTitle = new SpannableString(title);
        if (font != null && mNewTitle != null) {
            mNewTitle.setSpan(new CustomTypefaceSpan("", font), 0, mNewTitle.length(), Spannable.SPAN_INCLUSIVE_INCLUSIVE);
        }
        return mNewTitle;
    }

    /***
     * Set custom font for TextView
     *
     * @param text
     */
    public static void setCustomFont(TextView text, Typeface font) {
        if (font != null && text != null) {
            text.setTypeface(font);
        }
    }

    /***
     * Round corner of bitmap
     *
     * @param bitmap
     * @param pixels
     * @return Bitmap
     */
    public static Bitmap getRoundedCornerBitmap(Bitmap bitmap, int pixels) {
        Bitmap output = Bitmap.createBitmap(bitmap.getWidth(), bitmap
                .getHeight(), Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(output);

        final int color = 0xff424242;
        final Paint paint = new Paint();
        final Rect rect = new Rect(0, 0, bitmap.getWidth(), bitmap.getHeight());
        final RectF rectF = new RectF(rect);
        final float roundPx = pixels;

        paint.setAntiAlias(true);
        canvas.drawARGB(0, 0, 0, 0);
        paint.setColor(color);
        canvas.drawRoundRect(rectF, roundPx, roundPx, paint);

        paint.setXfermode(new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(bitmap, rect, rect, paint);

        return output;
    }

    /***
     * Find real path from uri. (convert media://content/id to 'file://sdcard/.../file.extension')
     *
     * @param context
     * @param contentUri
     * @return String
     */
    public static String getRealPathFromURI(Context context, Uri contentUri) {
        Cursor cursor = null;
        try {
            String[] proj = {MediaStore.Images.Media.DATA};
            cursor = context.getContentResolver().query(contentUri, proj, null, null, null);
            int column_index = cursor.getColumnIndexOrThrow(MediaStore.Images.Media.DATA);
            cursor.moveToFirst();
            return cursor.getString(column_index);
        } catch (NullPointerException exp) {
            return null;
        } finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    /***
     * Check href exist in black list
     *
     * @param href
     * @param context
     * @return
     */
    public static boolean isInMenuBlackList(String href, Context context) {
        if (!Config.getInstance(context).isShowDesktopVersion() && href.contains("/desktop-version")) {
            return true;
        }

        if(href.contains(".apk")){
            Information information = Config.getInstance(context).getInformation();
            if(information!=null && information.versionInformation.getLastVersionCode()!=-1 && information.versionInformation.getLastVersionCode() <= BuildConfig.VERSION_CODE){
                return true;
            }
        }

        return false;
    }

    /***
     * return main tag of locale
     *
     * @param tag
     * @return
     */
    public static String getMainTagOfLocale(String tag) {
        String tags[] = tag.split("-");
        return tags[0];
    }


    /***
     * Find icon from name
     *
     * @param href
     * @return
     */
    public static int getMenuIcon(String href) {
        if (href.contains("forum")) {
            return R.drawable.ic_menu_forum;
        } else if (href.contains("newsfeed")) {
            return R.drawable.ic_menu_newsfeed;
        } else if (href.contains("video")) {
            return R.drawable.ic_menu_video;
        } else if (href.contains("photo")) {
            return R.drawable.ic_menu_photo;
        } else if (href.contains("contact")) {
            return R.drawable.ic_menu_contacts;
        } else if (href.contains("rule")) {
            return R.drawable.ic_menu_rules;
        } else if (href.contains("download")) {
            return R.drawable.ic_menu_download;
        } else if (href.contains("news")) {
            return R.drawable.ic_menu_news;
        } else if (href.contains("group")) {
            return R.drawable.ic_menu_groups;
        } else if (href.contains("event")) {
            return R.drawable.ic_menu_calendar;
        } else if (href.contains("vitrin")) {
            return R.drawable.ic_menu_vitrin;
        } else if (href.contains("users")) {
            return R.drawable.ic_menu_users;
        } else if (href.contains("terms")) {
            return R.drawable.ic_menu_term;
        } else if (href.contains("exit")) {
            return R.drawable.ic_menu_exit;
        }else if (href.contains("dashboard")) {
            return R.drawable.ic_menu_dashboard;
        }else if (href.contains("audio")) {
            return R.drawable.ic_menu_audio;
        }else if (href.contains("userlogin")) {
            return R.drawable.ic_menu_userlogin;
        }else if (href.contains("index")) {
            return R.drawable.ic_menu_home;
        } else if (href.contains("fa")) {
            return R.drawable.ic_menu_fa;
        } else if (href.contains("en")) {
            return R.drawable.ic_menu_en;
        } else if (href.contains("demo")) {
            return R.drawable.demo;
        } else if (href.contains("doc")) {
            return R.drawable.doc;
        } else if (href.contains("apk")) {
            return R.drawable.android;
        }
        return R.drawable.ic_menu_other;
    }

    public static boolean isInArrayOfExtensions(String search) {
        return search.toLowerCase().contains("png")
                || search.toLowerCase().contains("jpg")
                || search.toLowerCase().contains("jpeg")
                || search.toLowerCase().contains("gif")
                || search.toLowerCase().contains("txt")
                || search.toLowerCase().contains("zip")
                || search.toLowerCase().contains("rar")
                || search.toLowerCase().contains("doc")
                || search.toLowerCase().contains("rtf")
                || search.toLowerCase().contains("apk")
                || search.toLowerCase().contains("pdf")
                || search.toLowerCase().contains("mp3")
                || search.toLowerCase().contains("mp4")
                || search.toLowerCase().contains("bmp")
                || search.toLowerCase().contains("xml")
                || search.toLowerCase().contains("xsl")
                || search.toLowerCase().contains("csv");

    }

    /***
     * Download files using url
     *
     * @param url
     * @param mainActivity
     */
    public static void downloadFile(final String url, final MainActivity mainActivity) {
        new Thread(new Runnable() {
            public void run() {
                downloadFileUsingConnection(url, mainActivity);
            }
        }).start();
    }


    public static void downloadFileUsingConnection(String download_file_path, MainActivity mainActivity) {
        String extension = MimeTypeMap.getFileExtensionFromUrl(download_file_path);
        String mimeType = null;
        if (extension != null && !extension.equals("")) {
            mimeType = MimeTypeMap.getSingleton().getMimeTypeFromExtension(extension.toLowerCase());
        }
        if (mainActivity != null && mimeType != null) {
            String file_name = Config.getInstance(mainActivity).getDownloadFolder() + "_" + String.valueOf(System.currentTimeMillis()) + "." + extension;

            //HTTPS does not support download manager
            if (Uri.parse(download_file_path).getScheme().equals("https")) {
                try {
                    String downloadFolderPath = Environment.getExternalStorageDirectory() + "/" + Config.getInstance(mainActivity).getDownloadFolder();
                    File folder = new File(downloadFolderPath);
                    if (!folder.exists()) {
                        folder.mkdir();
                    }
                    URL url = new URL(download_file_path);
                    HttpURLConnection urlConnection = (HttpURLConnection) url.openConnection();

                    urlConnection.setRequestMethod("GET");
                    urlConnection.setDoOutput(true);
                    urlConnection.connect();
                    showNotification(mainActivity.getResources().getString(R.string.downloading), mainActivity, Toast.LENGTH_SHORT);
                    //create a new file, to save the downloaded file
                    File file = new File(downloadFolderPath, file_name);
                    FileOutputStream fileOutput = new FileOutputStream(file);

                    //Stream used for reading the data from the internet
                    InputStream inputStream = urlConnection.getInputStream();

                    //create a buffer...
                    byte[] buffer = new byte[1024];
                    int bufferLength;

                    while ((bufferLength = inputStream.read(buffer)) > 0) {
                        fileOutput.write(buffer, 0, bufferLength);
                    }
                    fileOutput.close();
                    showNotification(mainActivity.getResources().getString(R.string.downloading_saved) + file_name, mainActivity, Toast.LENGTH_LONG);
                } catch (final MalformedURLException e) {
                    showNotification(mainActivity.getResources().getString(R.string.downloading_error), mainActivity, Toast.LENGTH_LONG);
                    e.printStackTrace();
                } catch (final IOException e) {
                    showNotification(mainActivity.getResources().getString(R.string.downloading_error), mainActivity, Toast.LENGTH_LONG);
                    e.printStackTrace();
                } catch (final Exception e) {
                    showNotification(mainActivity.getResources().getString(R.string.downloading_error), mainActivity, Toast.LENGTH_LONG);
                }
            } else {
                Uri uri = Uri.parse(download_file_path);
                DownloadManager downloadManager = (DownloadManager) mainActivity.getSystemService(Context.DOWNLOAD_SERVICE);
                DownloadManager.Request request = new DownloadManager.Request(uri);
                request.setTitle(file_name);
                request.setDescription(Config.getInstance(mainActivity).getDownloadFolder() + "_" + mainActivity.getResources().getString(R.string.app_name));
                request.setDestinationInExternalFilesDir(mainActivity, Environment.DIRECTORY_DOWNLOADS, file_name);
                downloadManager.enqueue(request);
                showNotification(mainActivity.getResources().getString(R.string.downloading) + " (" + file_name + ")", mainActivity, Toast.LENGTH_LONG);
            }

        }
    }

    public static void showNotification(final String text, final MainActivity mainActivity, final int length) {
        mainActivity.runOnUiThread(new Runnable() {
            public void run() {
                Toast.makeText(mainActivity, text, length).show();
            }
        });
    }
}
