package ir.iiscenter.shub;

import android.webkit.CookieManager;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.FirebaseInstanceIdService;

/**
 * Created by Alimardani on 10/8/16.
 */
public class MyFirebaseInstanceIDService extends FirebaseInstanceIdService {

    @Override
    public void onTokenRefresh() {
        // Get updated InstanceID token.
        String refreshedToken = FirebaseInstanceId.getInstance().getToken();
        CookieManager.getInstance().setCookie(Config.getInstance(getApplicationContext()).getHomeUrl(), "MobileTokenNotification=" + refreshedToken);
        CookieUtils.flushCookies();
    }
}
