package ir.iiscenter.shub;

import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.support.v4.app.NotificationCompat;
import android.support.v4.app.TaskStackBuilder;
import com.google.firebase.messaging.FirebaseMessagingService;
import com.google.firebase.messaging.RemoteMessage;
import org.json.JSONObject;
import java.util.Random;

/**
 * Created by Alimardani on 10/8/16.
 */
public class MyFirebaseMessagingService extends FirebaseMessagingService {
    @Override
    public void onMessageReceived(RemoteMessage remoteMessage) {

        String title = null;
        String description = null;
        String avatarUrl = null;
        String url = null;

        try {
            JSONObject object = new JSONObject(remoteMessage.getData());

            title = object.get("title").toString();
            description = object.get("description").toString();
            avatarUrl = object.get("avatarUrl").toString();
            url = object.get("url").toString();

        } catch (Exception e) {

        }

        if (title != null && description != null && !title.equals("check-user-activity")) {

            NotificationCompat.Builder mBuilder =
                    new NotificationCompat.Builder(this)
                            .setSmallIcon(R.mipmap.ic_launcher_raw)
                            .setContentTitle(title)
                            .setStyle(new NotificationCompat.BigTextStyle().bigText(description))
                            .setContentText(description);

            if (avatarUrl != null) {
                Bitmap bitmap = InformationReceiver.getBitmapFromURL(avatarUrl);
                mBuilder.setLargeIcon(bitmap);
            }

            // Creates an explicit intent for an Activity in your app
            Intent resultIntent = new Intent(this, MainActivity.class);

            resultIntent.putExtra("href", url);
            resultIntent.putExtra("fromNotification", "true");

            // The stack builder object will contain an artificial back stack for the
            // started Activity.
            // This ensures that navigating backward from the Activity leads out of
            // your application to the Home screen.
            TaskStackBuilder stackBuilder = TaskStackBuilder.create(this);

            // Adds the back stack for the Intent (but not the Intent itself)
            stackBuilder.addParentStack(MainActivity.class);

            // Adds the Intent that starts the Activity to the top of the stack
            stackBuilder.addNextIntent(resultIntent);
            PendingIntent resultPendingIntent = stackBuilder.getPendingIntent(0, PendingIntent.FLAG_UPDATE_CURRENT);
            mBuilder.setContentIntent(resultPendingIntent);
            mBuilder.setAutoCancel(true);

            NotificationManager mNotificationManager = (NotificationManager) getSystemService(Context.NOTIFICATION_SERVICE);

            // mId allows you to update the notification later on.
            mNotificationManager.notify(new Random().nextInt(), mBuilder.build());
        }
    }

}
