//
//  HomeViewController.swift
//  shub
//
//  Created by Yaser Alimardani (yaser.alimardany@gmail.com) on 10/14/1395 AP.
//  Copyright © 1395 IISCenter. All rights reserved.
//

import UIKit
import LMSideBarController
import Toast_Swift
class HomeViewController : UIViewController, UIWebViewDelegate, NSURLConnectionDelegate, UIScrollViewDelegate {
    
    var finishedLoading: Bool = true
    var loadingTimer: Timer? = nil
    var refController:UIRefreshControl = UIRefreshControl()
    var firstLoadFinished: Bool? = false
    var errorLoadingUrl: Bool? = false
    var lastValidUrl: String? = ""
    
    @IBOutlet weak var progressHome: UIProgressView!
    @IBOutlet weak var leftMenuButton: UIBarButtonItem!
    @IBOutlet weak var rightMenuButton: UIBarButtonItem!
    @IBOutlet weak var shubView: UIWebView!
    @IBOutlet weak var homeNavigationItem: UINavigationItem!
    @IBAction func rightMenuButtonTapped(_ sender: Any) {
        if !Config.sharedInstance.isRTL(){
            self.goBack()
        }else{
            let x: LMSideBarControllerDirection = LMSideBarControllerDirection(rawValue: 1)
            sideBarController.showMenuViewController(in: x)
        }
    }
    
    @IBAction func leftMenuButtonTapped(_ sender: Any) {
        if Config.sharedInstance.isRTL(){
            self.goBack()
        }else{
            let x: LMSideBarControllerDirection = LMSideBarControllerDirection(rawValue: 0)
            sideBarController.showMenuViewController(in: x)
        }
    }
    
    override func viewDidLoad() {
        self.initWebView()
        self.initLoadingIndicator()
        super.viewDidLoad()
        self.initConfig()
        self.homeNavigationItem.leftBarButtonItem = nil
        self.homeNavigationItem.rightBarButtonItem = nil
        self.loadUrl(url: Config.sharedInstance.getHomeUrl())
    }
    
    override func present(_ viewControllerToPresent: UIViewController, animated flag: Bool, completion: (() -> Void)? = nil) {
        self.progressHome.isHidden = true
        
    }
    
    override func dismiss(animated flag: Bool, completion: (() -> Void)? = nil) {
        self.progressHome.isHidden = true
    }
    
    func initConfig(){
        Config.sharedInstance.leftMenuButton = self.leftMenuButton
        Config.sharedInstance.rightMenuButton = self.rightMenuButton
        Config.sharedInstance.homeViewController = self
        UserDefaults.standard.register(defaults: ["UserAgent": Config.sharedInstance.getUserAgentDescription()])
    }
    
    func initLoadingIndicator(){
        self.progressHome.transform = self.progressHome.transform.scaledBy(x: 1, y: 2)
        view.backgroundColor = UIColor.white
        self.showLoadingIndicator()
        self.progressHome.isHidden = true
    }
    
    func initWebView(){
        Util.setNavigationFontFamily(isRtl: Config.sharedInstance.isRTL(), navigationController: self.navigationController!)
        self.shubView.delegate = self
        initRefreshController(title: "")
        self.shubView.scrollView.addSubview(refController)
        self.shubView.scrollView.delegate = self
    }
    
    func showLoadingIndicator() {
        self.loadingTimer?.invalidate()
        self.progressHome.isHidden = false
        self.progressHome.progress = 0.0
        self.finishedLoading = false
        self.loadingTimer = Timer.scheduledTimer(timeInterval: 0.01667, target: self, selector: #selector(self.loadingTimerCallback), userInfo: nil, repeats: true)
        self.title = ""
    }
    
    func hideLoadingIndocator() {
        self.finishedLoading = true
    }
    
    
    func loadingTimerCallback() {
        if self.finishedLoading {
            if self.progressHome.progress >= 1 {
                self.progressHome.isHidden = true
                self.loadingTimer?.invalidate()
            } else {
                self.progressHome.progress += 0.005
            }
        } else {
            self.progressHome.progress += 0.001
            if self.progressHome.progress >= 0.75 {
                self.progressHome.progress = 0.75
            }
        }
    }
    
    func webViewDidStartLoad(_ webView: UIWebView) {
        Util.setNavigationFontFamily(isRtl: Config.sharedInstance.isRTL(), navigationController: self.navigationController!)
        UIApplication.shared.isNetworkActivityIndicatorVisible = true
        self.showLoadingIndicator()
        Util.setCookie(cookieValue: Config.sharedInstance.getUsingMobileCookieLabel())
    }
    
    func webView(_ webView: UIWebView, shouldStartLoadWith request: URLRequest, navigationType: UIWebViewNavigationType) -> Bool {
        let isInEmbedUrl: Bool = NavigationHelper.isInEmbedUrlSupport(url: request.url!)
        if (request.url != request.mainDocumentURL && isInEmbedUrl) || !NavigationHelper.checkUrlForOverriding(url: request.url!){
            let lastUrl = request.url?.absoluteString
            if !(lastUrl?.contains("error.html"))! && NavigationHelper.isInternalUri(url: request.url!){
                self.lastValidUrl = lastUrl
            }
            return true
        }else{
            return false
        }
    }
    
    func webViewDidFinishLoad(_ webView: UIWebView) {
        if self.errorLoadingUrl!{
            self.title = "ERROR_LABEL".localized(lang: self.getCurrentLanguageTag())
            self.errorLoadingUrl = false
            let lastShubViewUrl = self.getLastWebviewUrl()
            let errorDescription: String = "ERROR_IN_CONNECTING".localized(lang: getCurrentLanguageTag())
            let retryLabel: String = "TRY_AGAIN".localized(lang: getCurrentLanguageTag())
            
            self.shubView.stringByEvaluatingJavaScript(from: "document.getElementById('errorDescription').innerHTML = '\(errorDescription)';")
            self.shubView.stringByEvaluatingJavaScript(from: "document.getElementById('reloadButton').innerHTML = '\(retryLabel)';")
            self.shubView.stringByEvaluatingJavaScript(from: "function reload(){window.location = '\(lastShubViewUrl)'}")
            self.shubView.stringByEvaluatingJavaScript(from: "showReloadButton();")
            self.progressHome.progress = 1
            self.hideLoadingIndocator()
        }
        self.firstLoadFinished = true
        updateInformation()
        UIApplication.shared.isNetworkActivityIndicatorVisible = false
    }
    
    func webView(_ webView: UIWebView, didFailLoadWithError error: Error) {
        var isError: Bool = true
        if let userInfo: NSDictionary = error._userInfo as! NSDictionary? {
            if let _ = userInfo["NSLocalizedDescription"] as? String{
                //Its Error
                //Nothing to do
            }else{
                //Its not error
                //example: Iframe error in the page
                isError = false
            }
        }
        if isError == true {
            self.errorLoadingUrl = true
            let url = Bundle.main.url(forResource: "error", withExtension: "html")
            self.loadUrlWithUrl(url: url!)
        }
    }
    
    func getLastWebviewUrl() -> String{
        if self.lastValidUrl != ""{
            return self.lastValidUrl!
        }
        return Config.sharedInstance.getHomeUrl()
    }
    
    func reload(refresh:UIRefreshControl){
        self.refController.beginRefreshing()
    }
    
    func loadUrl(url: String){
        let url = URL(string: url)
        self.loadUrlWithUrl(url: url!)
    }
    
    func loadUrlWithUrl(url: URL){
        if checkInternetConnection(){
            let urlRequest = URLRequest(url: url)
            shubView.loadRequest(urlRequest)
        }
    }
    
    func checkInternetConnection() -> Bool{
        if !Reachability.isInternetAvailable(){
            self.showToast(string: "NO_INTERNET_DESCRIPTION".localized(lang: self.getCurrentLanguageTag()))
            self.title = "APP_NAME_NO_INTERNET".localized(lang: self.getCurrentLanguageTag())
            return false
        }
        self.title = "CONNECTING".localized(lang: self.getCurrentLanguageTag())
        return true
    }
    
    func getCurrentLanguageTag() -> String{
        var currentLanguageTag: String = "fa-IR"
        if let information = Config.sharedInstance.information{
            let languageMenuItem = information.languageMenuItems
            for item in languageMenuItem {
                if item.isCurrent{
                    currentLanguageTag = item.tag
                }
            }
        }
        
        return currentLanguageTag
    }
    
    func showToast(string: String){
        let style = ToastStyle()
        self.view.makeToast(string, duration: 2.0, position: .bottom, style: style)
        ToastManager.shared.style = style
        ToastManager.shared.tapToDismissEnabled = true
        ToastManager.shared.queueEnabled = true
    }
    
    func updateInformation(){
        InformationReceiver().getInformation{
            information in
            self.manageInformation(information: information)
        }
    }
    
    func initRefreshController(title: String){
        refController.addTarget(self, action: #selector(self.reload(refresh:)), for: UIControlEvents.valueChanged)
        refController.backgroundColor = UIColor.white
        refController.bounds = CGRect(origin: CGPoint(x: 0,y :0), size: CGSize(width: refController.bounds.size.width, height: refController.bounds.size.height/2))
        refController.attributedTitle = NSAttributedString(string: title)
    }
    
    func scrollViewWillEndDragging(_ scrollView: UIScrollView, withVelocity velocity: CGPoint, targetContentOffset: UnsafeMutablePointer<CGPoint>) {
        if (refController.bounds.height/2)>=56{
            self.loadUrl(url: self.getLastWebviewUrl())
        }
        if(refController.isRefreshing){
            refController.endRefreshing()
        }
    }
    
    func manageInformation(information: Information){
        Config.sharedInstance.information = information
        self.reloadSideBarControllerUsingLanguage()
    }
    
    func reloadSideBarControllerUsingLanguage(){
        
        if let information = Config.sharedInstance.information{
            let languageMenuItem = information.languageMenuItems
            for item in languageMenuItem {
                if item.isCurrent{
                    Config.sharedInstance.isRtl = item.isRTL
                }
            }
        }
        
        var userLabel: String = "GUEST_LABEL".localized(lang: self.getCurrentLanguageTag())
        var userEmail: String = ""
        var avatarUrl: String = ""
        var signLabel: String = "LOGIN_LABEL".localized(lang: self.getCurrentLanguageTag())
        var registerLabel: String = "REGISTER_LABEL".localized(lang: self.getCurrentLanguageTag())
        if Config.sharedInstance.information?.user.name != ""{
            userLabel = (Config.sharedInstance.information?.user.name)!
            userEmail = (Config.sharedInstance.information?.user.email)!
            avatarUrl = (Config.sharedInstance.information?.user.avatar)!
            signLabel = "LOGOUT_LABEL".localized(lang: self.getCurrentLanguageTag())
            registerLabel = ""
        }
        
        DispatchQueue.main.async{
            var avatarData: NSData? = nil
            if avatarUrl != ""{
                let strUrl = NSURL(string: avatarUrl)
                avatarData = NSData(contentsOf: strUrl as! URL)
            }
            
            var avatarImage: UIImage = UIImage(named: "guest.png")!
            var loginImage: UIImage = UIImage(named: "login.png")!
            if avatarData != nil{
                avatarImage = UIImage(data: avatarData as! Data)!
                loginImage = UIImage(named: "signout.png")!
            }
            
            if let rightMenuViewController = Config.sharedInstance.rightViewController{
                rightMenuViewController.menuTitles = Util.getMenuItems()
                rightMenuViewController.tableData.reloadData()
                rightMenuViewController.userLabel.text = userLabel
                rightMenuViewController.userEmail.text = userEmail
                rightMenuViewController.avatarImageView.image = avatarImage
                rightMenuViewController.loginImageView.image = loginImage
                rightMenuViewController.signLabel.text = signLabel
                rightMenuViewController.registerLabel.text = registerLabel
                if avatarData != nil{
                    rightMenuViewController.registerImageView.isHidden = true
                }else{
                    rightMenuViewController.registerImageView.isHidden = false
                }
            }
        
            if let leftMenuViewController = Config.sharedInstance.leftViewController{
                leftMenuViewController.menuTitles = Util.getMenuItems()
                leftMenuViewController.tableData.reloadData()
                leftMenuViewController.userLabel.text = userLabel
                leftMenuViewController.userEmail.text = userEmail
                leftMenuViewController.avatarImageView.image = avatarImage
                leftMenuViewController.loginImageView.image = loginImage
                leftMenuViewController.signLabel.text = signLabel
                leftMenuViewController.registerLabel.text = registerLabel
                if avatarData != nil{
                    leftMenuViewController.registerImageView.isHidden = true
                }else{
                    leftMenuViewController.registerImageView.isHidden = false
                }
            }
            
            if Config.sharedInstance.isRTL(){
                Config.sharedInstance.rootViewController?.setSideBarStyle(Config.sharedInstance.rootViewController?.sideBarDepthStyle, for: LMSideBarControllerDirection(rawValue: 1))
                self.homeNavigationItem.rightBarButtonItem = Config.sharedInstance.rightMenuButton
                self.homeNavigationItem.rightBarButtonItem?.image = UIImage(named: "btn_right_menu.png")!
                self.homeNavigationItem.leftBarButtonItem = nil
                if self.shubView.canGoBack{
                    self.homeNavigationItem.leftBarButtonItem = Config.sharedInstance.leftMenuButton
                    self.homeNavigationItem.leftBarButtonItem?.image = UIImage(named: "back-left.png")!
                }
            }else{
                Config.sharedInstance.rootViewController?.setSideBarStyle(Config.sharedInstance.rootViewController?.sideBarDepthStyle, for: LMSideBarControllerDirection(rawValue: 0))
                self.homeNavigationItem.leftBarButtonItem = Config.sharedInstance.leftMenuButton
                self.homeNavigationItem.leftBarButtonItem?.image = UIImage(named: "btn_left_menu.png")!
                self.homeNavigationItem.rightBarButtonItem = nil
                if self.shubView.canGoBack{
                    self.homeNavigationItem.rightBarButtonItem = Config.sharedInstance.rightMenuButton
                    self.homeNavigationItem.rightBarButtonItem?.image = UIImage(named: "back-right.png")!
                }
            }
            
            
            self.hideLoadingIndocator()
        }
    }
    
    func goBack(){
        if self.shubView.canGoBack{
            self.shubView.goBack()
        }
    }
}
