//
//  InformationReceiver.swift
//  shub
//
//  Created by Yaser Alimardani (yaser.alimardany@gmail.com) on 10/11/1395 AP.
//  Copyright © 1395 IISCenter. All rights reserved.
//

import Foundation
class InformationReceiver{
    func getInformation(completion: @escaping (Information) -> ()){
        let url = NSURL(string: Config.sharedInstance.getInformationUrl())
        let request = NSMutableURLRequest(url: url! as URL)
        request.setValue(Config.sharedInstance.getUserAgentDescription(), forHTTPHeaderField: "User-Agent")
        request.httpMethod = "GET"
        
        let task = URLSession.shared.dataTask(with: request as URLRequest){data,response,error in
            
            if error != nil {
                return
            }
            
            var errorInParsJson: Bool = false
            
            do {
                if let _ = try JSONSerialization.jsonObject(with: data!, options: []) as? [String:Any] {
                    //Nothing to do
                }else{
                    errorInParsJson = true
                }
            }catch {
                errorInParsJson = true
            }
            
            var menuTypeMainItems = [MyMenuItem]()
            var menuTypeBottomItems = [MyMenuItem]()
            var languageItems = [MyMenuItem]()
            let user = User(name: "", email: "", avatar: "", profileUrl: "")
            
            if errorInParsJson{
                let information = Information(mainMenuItems: menuTypeMainItems, footerMenuItems: menuTypeBottomItems, languageMenuItems: languageItems, user: user)
                
                completion(information)
                return
            }
            
            let json = try! JSONSerialization.jsonObject(with: data!, options: JSONSerialization.ReadingOptions.allowFragments) as! [String:AnyObject]
            
            if json["menuTypeMainItems"] != nil{
                let menuTypeMainItemsJson = json["menuTypeMainItems"] as! NSArray
                for index in 0...menuTypeMainItemsJson.count-1{
                    let item = menuTypeMainItemsJson[index] as! [String: AnyObject]
                    let objectItem = MyMenuItem(label: item["label"]! as! String, href: item["url"]! as! String)
                    if !Util.isInBlackListMenuItems(string: item["url"]! as! String){
                        menuTypeMainItems.append(objectItem)
                    }
                }
            }
            
            if json["menuTypeBottomItems"] != nil{
                let menuTypeBottomItemsJson = json["menuTypeBottomItems"] as! NSArray
                for index in 0...menuTypeBottomItemsJson.count-1{
                    let item = menuTypeBottomItemsJson[index] as! [String: AnyObject]
                    let objectItem = MyMenuItem(label: item["label"]! as! String, href: item["url"]! as! String)
                    if !Util.isInBlackListMenuItems(string: item["url"]! as! String){
                        menuTypeBottomItems.append(objectItem)
                    }
                }
            }
            
            if json["languageItems"] != nil{
                let languageItemsJson = json["languageItems"] as! NSArray
                for index in 0...languageItemsJson.count-1{
                    let item = languageItemsJson[index] as! [String: AnyObject]
                    let objectItem = MyMenuItem(label: item["label"]! as! String, href: Config.sharedInstance.getHomeUrl() + "?language_id="+(item["id"]! as! String))
                    let isRtl = item["isRtl"] as! String
                    if isRtl == "1"{
                        objectItem.isRTL = true
                    }
                    
                    if let isCurrent = item["is_current"]{
                        if isCurrent as! Bool == true{
                            objectItem.isCurrent = true
                        }
                    }
                        
                    objectItem.tag = item["tag"] as! String
                    objectItem.languageId = item["id"] as! String
                    languageItems.append(objectItem)
                }
            }
            
            if let userJson = json["userInformation"]{
                if let _ = userJson["name"]{
                    user.name = userJson["name"]! as! String
                    user.email = userJson["email"]! as! String
                    user.avatar = userJson["avatarUrl"]! as! String
                    user.profileUrl = userJson["profileUrl"]! as! String
                }
            }
            
            let information = Information(mainMenuItems: menuTypeMainItems, footerMenuItems: menuTypeBottomItems, languageMenuItems: languageItems, user: user)
            
            completion(information)
        }
        
        task.resume()
    }
}
