//
//  RightMenuController.swift
//  shub
//
//  Created by Yaser Alimardani (yaser.alimardany@gmail.com) on 10/15/1395 AP.
//  Copyright © 1395 IISCenter. All rights reserved.
//

import UIKit

class RightMenuController : UIViewController, UITableViewDelegate, UITableViewDataSource {
    
    @IBOutlet weak var registerImageView: UIImageView!
    @IBOutlet weak var loginImageView: UIImageView!
    @IBOutlet weak var tableData: UITableView!
    @IBOutlet weak var signLabel: UILabel!
    @IBOutlet weak var userLabel: UILabel!
    @IBOutlet weak var registerLabel: UILabel!
    @IBOutlet weak var userEmail: UILabel!
    @IBOutlet weak var avatarImageView: UIImageView!
    
    var menuTitles: [MyMenuItem] = []

    override func viewDidLoad() {
        self.menuTitles = Util.getMenuItems()
        let imageProfileClicked = UITapGestureRecognizer(target: self, action: #selector(self.imageProfileTapped))
        let imageRegisterClicked = UITapGestureRecognizer(target: self, action: #selector(self.imageRegisterTapped))
        let imageLoginClicked = UITapGestureRecognizer(target: self, action: #selector(self.imageLoginTapped))
        
        let registerLabelClicked = UITapGestureRecognizer(target: self, action: #selector(self.imageRegisterTapped))
        let loginLabelClicked = UITapGestureRecognizer(target: self, action: #selector(self.imageLoginTapped))
        
        Util.initMenuResources(avatarImageView: self.avatarImageView, registerImageView: self.registerImageView, loginImageView: self.loginImageView, imageProfileClicked: imageProfileClicked, imageRegisterClicked: imageRegisterClicked, imageLoginClicked: imageLoginClicked, loginLabel: self.signLabel, registerLabel: self.registerLabel, loginLabelClicked: loginLabelClicked, registerLabelClicked: registerLabelClicked)
    }
    
    func imageLoginTapped(object: AnyObject){
        Util.imageLoginTapped()
        sideBarController.hideMenuViewController(true)
    }
    
    func imageRegisterTapped(object: AnyObject){
        Util.imageRegisterTapped()
        sideBarController.hideMenuViewController(true)
    }
    
    func imageProfileTapped(object: AnyObject){
        Util.imageProfileTapped()
        sideBarController.hideMenuViewController(true)
    }
    
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return self.menuTitles.count
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        return Util.getCellInformationOfMenu(indexPath: indexPath, tableView: tableView, menuTitles: menuTitles, align: .right)
    }

    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        Util.selectMenuItem(indexPath: indexPath, tableView: tableView, menuTitles: menuTitles)
        sideBarController.hideMenuViewController(true)
    }
}
