//
//  RootViewController.swift
//  shub
//
//  Created by Yaser Alimardani (yaser.alimardany@gmail.com) on 10/14/1395 AP.
//  Copyright © 1395 IISCenter. All rights reserved.
//

import Foundation
import LMSideBarController


class RootViewController: LMSideBarController,  LMSideBarControllerDelegate {
    var isStatusHidden:Bool = false
    var sideBarDepthStyle: LMSideBarDepthStyle = LMSideBarDepthStyle()
    
    
    override func awakeFromNib() {
        let storyboard = UIStoryboard(name: "Main", bundle: nil)
        sideBarDepthStyle.menuWidth = 220
        let leftMenuViewController: LeftMenuController = storyboard.instantiateViewController(withIdentifier: "LeftMenuController") as! LeftMenuController
        
        Config.sharedInstance.leftViewController = leftMenuViewController
        
        let rightMenuViewController: RightMenuController = storyboard.instantiateViewController(withIdentifier: "RightMenuController") as! RightMenuController
        Config.sharedInstance.rightViewController = rightMenuViewController
        
        let navigationController: NavigationController = storyboard.instantiateViewController(withIdentifier: "mainNavigationController") as! NavigationController
        Config.sharedInstance.navigationController = navigationController
        
        
        self.panGestureEnabled = true
        self.delegate = self
        
        self.setMenuView(leftMenuViewController, for: LMSideBarControllerDirection(rawValue: 0))
        self.setMenuView(rightMenuViewController, for: LMSideBarControllerDirection(rawValue: 1))
        
        Config.sharedInstance.rootViewController = self
        contentViewController = navigationController
    }
}
