//
//  Util.swift
//  shub
//
//  Created by Yaser Alimardani (yaser.alimardany@gmail.com) on 10/15/1395 AP.
//  Copyright © 1395 IISCenter. All rights reserved.
//

import Foundation
class Util{
    static func getMenuItems() -> [MyMenuItem]{
        var titles: [MyMenuItem] = []
        if let information = Config.sharedInstance.information{
            let topMenuItem = information.mainMenuItems
            for item in topMenuItem {
                titles.append(item)
            }
            
            let footerMenuItem = information.footerMenuItems
            for item in footerMenuItem {
                titles.append(item)
            }
            
            let languageMenuItem = information.languageMenuItems
            if languageMenuItem.count > 1 {
                for item in languageMenuItem {
                    titles.append(item)
                }
            }
        }
        return titles
    }
    
    static func setCookie(cookieValue: String){
        let cookieHeaderField = ["Set-Cookie": cookieValue]
        let cookies = HTTPCookie.cookies(withResponseHeaderFields: cookieHeaderField, for: URL(string: Config.sharedInstance.getHomeUrl())!)
        HTTPCookieStorage.shared.setCookies(cookies, for: URL(string: Config.sharedInstance.getHomeUrl())!, mainDocumentURL: URL(string: Config.sharedInstance.getHomeUrl())!)
    }
    
    static func selectMenuItem(indexPath: IndexPath, tableView: UITableView, menuTitles: [MyMenuItem]){
        tableView.deselectRow(at: indexPath, animated: true)
        let itemSelected : MyMenuItem = menuTitles[indexPath.row]
        if itemSelected.languageId==""{
                //Nothing to do
        }else{
            Util.setCookie(cookieValue: "base_language_id=" + itemSelected.languageId)
            Config.sharedInstance.isRtl = itemSelected.isRTL
        }
        Config.sharedInstance.homeViewController?.loadUrl(url: itemSelected.href)
    }
    
    static func getCellInformationOfMenu(indexPath: IndexPath, tableView: UITableView, menuTitles: [MyMenuItem], align: NSTextAlignment) -> UITableViewCell{
        let cellIdentifier: String = "menuCell"
        var cell = UITableViewCell(style: UITableViewCellStyle.subtitle, reuseIdentifier: cellIdentifier)
        
        if align == .right{
            cell = UITableViewCell(style: UITableViewCellStyle.default, reuseIdentifier: cellIdentifier)
            cell.textLabel?.textAlignment = .right
            cell.detailTextLabel?.textAlignment = .right
            cell.textLabel?.font? = UIFont(name: Config.sharedInstance.getPersianFont(), size:17)!
        }else{
            cell.textLabel?.font? = UIFont(name:"Times New Roman", size:17)!
        }
        cell.textLabel?.text = menuTitles[indexPath.row].label
        cell.textLabel?.textColor = UIColor(white: 0.11, alpha: 1)
        cell.backgroundColor = UIColor.clear
        
        return cell;
    }
    
    static func imageLoginTapped(){
        let profileUrl = Config.sharedInstance.information?.user.profileUrl
        if profileUrl != ""{
            Config.sharedInstance.homeViewController?.loadUrl(url: Config.sharedInstance.getSignOutUrl())
        }else{
            Config.sharedInstance.homeViewController?.loadUrl(url: Config.sharedInstance.getSignInUrl())
        }
    }
    
    static func imageRegisterTapped(){
        Config.sharedInstance.homeViewController?.loadUrl(url: Config.sharedInstance.getJoinUrl())
    }
    
    static func imageProfileTapped(){
        let profileUrl = Config.sharedInstance.information?.user.profileUrl
        if profileUrl != ""{
            Config.sharedInstance.homeViewController?.loadUrl(url: profileUrl!)
        }else{
            Config.sharedInstance.homeViewController?.loadUrl(url: Config.sharedInstance.getSignInUrl())
        }
    }
    
    static func initMenuResources(avatarImageView: UIImageView, registerImageView: UIImageView, loginImageView: UIImageView, imageProfileClicked: UITapGestureRecognizer, imageRegisterClicked: UITapGestureRecognizer, imageLoginClicked: UITapGestureRecognizer, loginLabel: UILabel, registerLabel: UILabel, loginLabelClicked: UITapGestureRecognizer, registerLabelClicked: UITapGestureRecognizer){
        avatarImageView.clipsToBounds = true
        avatarImageView.layer.cornerRadius = 35.0
        avatarImageView.layer.borderColor = UIColor.white.cgColor
        avatarImageView.layer.borderWidth = 2.0
        avatarImageView.layer.rasterizationScale = UIScreen.main.scale
        avatarImageView.layer.shouldRasterize = true
        avatarImageView.isUserInteractionEnabled = true
        avatarImageView.addGestureRecognizer(imageProfileClicked)
        
        registerImageView.isUserInteractionEnabled = true
        registerImageView.addGestureRecognizer(imageRegisterClicked)
        
        registerLabel.isUserInteractionEnabled = true
        registerLabel.addGestureRecognizer(registerLabelClicked)
        
        loginImageView.isUserInteractionEnabled = true
        loginImageView.addGestureRecognizer(imageLoginClicked)
        
        loginLabel.isUserInteractionEnabled = true
        loginLabel.addGestureRecognizer(loginLabelClicked)
    }
    
    static func isInBlackListMenuItems(string: String) -> Bool{
        if Config.sharedInstance.isShowDesktopVersion() == false && string.contains("desktop-version"){
            return true
        }
        
        if string.contains(".apk"){
            return true
        }
        
        return false
    }
    
    static func setNavigationFontFamily(isRtl: Bool, navigationController: UINavigationController){
        var fontName: String = "Times New Roman"
        if isRtl{
            fontName = Config.sharedInstance.getPersianFont()
        }
        let attrs = [
            NSForegroundColorAttributeName: UIColor.black,
            NSFontAttributeName: UIFont(name: fontName, size: 17)!
        ]
        navigationController.navigationBar.titleTextAttributes = attrs
    }
    
    static func getInitialHost() -> String{
        let homeUrl: String = (URL(string: Config.sharedInstance.getHomeUrl())?.host)!
        if homeUrl.hasPrefix("www."){
            return homeUrl.substring(from: homeUrl.index(homeUrl.startIndex, offsetBy: 4))
        }
        
        return homeUrl
    }
    
    static func isDownloadableUrl(string: String) -> Bool{
        if string.lowercased().contains("png") || string.lowercased().contains("jpg") || string.lowercased().contains("jpeg") || string.lowercased().contains("gif") || string.lowercased().contains("txt") || string.lowercased().contains("zip") || string.lowercased().contains("rar") || string.lowercased().contains("doc") || string.lowercased().contains("rtf") || string.lowercased().contains("apk") || string.lowercased().contains("pdf") || string.lowercased().contains("mp3") || string.lowercased().contains("mp4") || string.lowercased().contains("bmp") || string.lowercased().contains("xml") || string.lowercased().contains("xsl") || string.lowercased().contains("csv")
            {
                return true
        }
        return false
    }
}
